/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.debezium.utils;

import com.ververica.cdc.debezium.internal.SchemaRecord;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DatabaseHistoryUtil {
    private static final Map<String, Collection<SchemaRecord>> HISTORY = new HashMap<String, Collection<SchemaRecord>>();
    private static final Map<String, Boolean> HISTORY_CLEANUP_STATUS = new HashMap<String, Boolean>();

    private DatabaseHistoryUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerHistory(String engineName, Collection<SchemaRecord> engineHistory) {
        Map<String, Collection<SchemaRecord>> map = HISTORY;
        synchronized (map) {
            HISTORY.put(engineName, engineHistory);
            HISTORY_CLEANUP_STATUS.put(engineName, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeHistory(String engineName) {
        Map<String, Collection<SchemaRecord>> map = HISTORY;
        synchronized (map) {
            HISTORY_CLEANUP_STATUS.put(engineName, true);
            HISTORY.remove(engineName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<SchemaRecord> retrieveHistory(String engineName) {
        Map<String, Collection<SchemaRecord>> map = HISTORY;
        synchronized (map) {
            if (Boolean.TRUE.equals(HISTORY_CLEANUP_STATUS.get(engineName))) {
                throw new IllegalStateException(String.format("Retrieve schema history failed, the schema records for engine %s has been removed, this might because the debezium engine has been shutdown due to other errors.", engineName));
            }
            return HISTORY.getOrDefault(engineName, Collections.emptyList());
        }
    }
}

