/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mongodb.source;

import com.ververica.cdc.connectors.base.config.SourceConfig;
import com.ververica.cdc.connectors.base.dialect.DataSourceDialect;
import com.ververica.cdc.connectors.base.source.IncrementalSource;
import com.ververica.cdc.connectors.base.source.meta.offset.OffsetFactory;
import com.ververica.cdc.connectors.base.source.meta.split.SourceRecords;
import com.ververica.cdc.connectors.base.source.meta.split.SourceSplitState;
import com.ververica.cdc.connectors.base.source.metrics.SourceReaderMetrics;
import com.ververica.cdc.connectors.mongodb.source.MongoDBSourceBuilder;
import com.ververica.cdc.connectors.mongodb.source.config.MongoDBSourceConfig;
import com.ververica.cdc.connectors.mongodb.source.config.MongoDBSourceConfigFactory;
import com.ververica.cdc.connectors.mongodb.source.dialect.MongoDBDialect;
import com.ververica.cdc.connectors.mongodb.source.offset.ChangeStreamOffsetFactory;
import com.ververica.cdc.connectors.mongodb.source.reader.MongoDBRecordEmitter;
import com.ververica.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.base.source.reader.RecordEmitter;

@Internal
@Experimental
public class MongoDBSource<T>
extends IncrementalSource<T, MongoDBSourceConfig> {
    private static final long serialVersionUID = 1L;

    MongoDBSource(MongoDBSourceConfigFactory configFactory, DebeziumDeserializationSchema<T> deserializationSchema) {
        super((SourceConfig.Factory)configFactory, deserializationSchema, (OffsetFactory)new ChangeStreamOffsetFactory(), (DataSourceDialect)new MongoDBDialect());
    }

    @PublicEvolving
    public static <T> MongoDBSourceBuilder<T> builder() {
        return new MongoDBSourceBuilder();
    }

    protected RecordEmitter<SourceRecords, T, SourceSplitState> createRecordEmitter(SourceConfig sourceConfig, SourceReaderMetrics sourceReaderMetrics) {
        return new MongoDBRecordEmitter(this.deserializationSchema, sourceReaderMetrics, this.offsetFactory);
    }
}

