/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mongodb.source.assigners.splitters;

import com.ververica.cdc.connectors.base.source.assigner.splitter.ChunkSplitter;
import com.ververica.cdc.connectors.base.source.meta.split.SnapshotSplit;
import com.ververica.cdc.connectors.mongodb.source.assigners.splitters.ShardedSplitStrategy;
import com.ververica.cdc.connectors.mongodb.source.assigners.splitters.SplitContext;
import com.ververica.cdc.connectors.mongodb.source.assigners.splitters.SplitVectorSplitStrategy;
import com.ververica.cdc.connectors.mongodb.source.config.MongoDBSourceConfig;
import io.debezium.relational.TableId;
import java.util.Collection;
import org.apache.flink.annotation.Experimental;

@Experimental
public class MongoDBChunkSplitter
implements ChunkSplitter {
    private final MongoDBSourceConfig sourceConfig;

    public MongoDBChunkSplitter(MongoDBSourceConfig sourceConfig) {
        this.sourceConfig = sourceConfig;
    }

    public Collection<SnapshotSplit> generateSplits(TableId collectionId) {
        SplitContext splitContext = SplitContext.of(this.sourceConfig, collectionId);
        if (splitContext.isShardedCollection()) {
            return ShardedSplitStrategy.INSTANCE.split(splitContext);
        }
        return SplitVectorSplitStrategy.INSTANCE.split(splitContext);
    }
}

