/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mongodb.source.assigners.splitters;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Aggregates;
import com.ververica.cdc.connectors.base.source.meta.split.SnapshotSplit;
import com.ververica.cdc.connectors.mongodb.source.assigners.splitters.SingleSplitStrategy;
import com.ververica.cdc.connectors.mongodb.source.assigners.splitters.SplitContext;
import com.ververica.cdc.connectors.mongodb.source.assigners.splitters.SplitStrategy;
import com.ververica.cdc.connectors.mongodb.source.dialect.MongoDBDialect;
import com.ververica.cdc.connectors.mongodb.source.utils.ChunkUtils;
import com.ververica.cdc.connectors.mongodb.source.utils.MongoUtils;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.logical.RowType;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

@Internal
public class SampleBucketSplitStrategy
implements SplitStrategy {
    public static final SampleBucketSplitStrategy INSTANCE = new SampleBucketSplitStrategy();
    private static final int DEFAULT_SAMPLING_THRESHOLD = 102400;
    private static final double DEFAULT_SAMPLING_RATE = 0.05;

    private SampleBucketSplitStrategy() {
    }

    @Override
    public Collection<SnapshotSplit> split(SplitContext splitContext) {
        long chunkSizeInBytes = splitContext.getChunkSizeMB() * 1024 * 1024;
        long sizeInBytes = splitContext.getSizeInBytes();
        long count = splitContext.getDocumentCount();
        if (sizeInBytes < chunkSizeInBytes) {
            return SingleSplitStrategy.INSTANCE.split(splitContext);
        }
        int numChunks = (int)(sizeInBytes / chunkSizeInBytes) + 1;
        int numberOfSamples = count < 102400L ? (int)count : (int)Math.floor((double)count * 0.05);
        TableId collectionId = splitContext.getCollectionId();
        MongoCollection<BsonDocument> collection = MongoUtils.collectionFor(splitContext.getMongoClient(), collectionId, BsonDocument.class);
        ArrayList<Bson> pipeline = new ArrayList<Bson>();
        if ((long)numberOfSamples != count) {
            pipeline.add(Aggregates.sample((int)numberOfSamples));
        }
        pipeline.add(Aggregates.bucketAuto((Object)"$_id", (int)numChunks));
        List chunks = (List)collection.aggregate(pipeline).allowDiskUse(Boolean.valueOf(true)).into(new ArrayList());
        RowType rowType = this.shardKeysToRowType(Collections.singleton("_id"));
        ArrayList<SnapshotSplit> snapshotSplits = new ArrayList<SnapshotSplit>(chunks.size() + 2);
        HashMap<TableId, TableChanges.TableChange> schema = new HashMap<TableId, TableChanges.TableChange>();
        schema.put(collectionId, MongoDBDialect.collectionSchema(collectionId));
        SnapshotSplit firstSplit = new SnapshotSplit(collectionId, this.splitId(collectionId, 0), rowType, ChunkUtils.minLowerBoundOfId(), ChunkUtils.boundOfId(this.lowerBoundOfBucket((BsonDocument)chunks.get(0))), null, schema);
        snapshotSplits.add(firstSplit);
        for (int i = 0; i < chunks.size(); ++i) {
            BsonDocument bucket = (BsonDocument)chunks.get(i);
            snapshotSplits.add(new SnapshotSplit(collectionId, this.splitId(collectionId, i + 1), rowType, ChunkUtils.boundOfId(this.lowerBoundOfBucket(bucket)), ChunkUtils.boundOfId(this.upperBoundOfBucket(bucket)), null, schema));
        }
        SnapshotSplit lastSplit = new SnapshotSplit(collectionId, this.splitId(collectionId, chunks.size() + 1), rowType, ChunkUtils.boundOfId(this.upperBoundOfBucket((BsonDocument)chunks.get(chunks.size() - 1))), ChunkUtils.maxUpperBoundOfId(), null, schema);
        snapshotSplits.add(lastSplit);
        return snapshotSplits;
    }

    private BsonDocument bucketBounds(BsonDocument bucket) {
        return bucket.getDocument((Object)"_id");
    }

    private BsonValue lowerBoundOfBucket(BsonDocument bucket) {
        return this.bucketBounds(bucket).get((Object)"min");
    }

    private BsonValue upperBoundOfBucket(BsonDocument bucket) {
        return this.bucketBounds(bucket).get((Object)"max");
    }
}

