/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mongodb.source.assigners.splitters;

import com.mongodb.client.MongoClient;
import com.ververica.cdc.connectors.mongodb.source.config.MongoDBSourceConfig;
import com.ververica.cdc.connectors.mongodb.source.utils.MongoUtils;
import io.debezium.relational.TableId;
import org.apache.flink.annotation.Internal;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonNumber;

@Internal
public class SplitContext {
    private final MongoClient mongoClient;
    private final TableId collectionId;
    private final BsonDocument collectionStats;
    private final int chunkSizeMB;

    public SplitContext(MongoClient mongoClient, TableId collectionId, BsonDocument collectionStats, int chunkSizeMB) {
        this.mongoClient = mongoClient;
        this.collectionId = collectionId;
        this.collectionStats = collectionStats;
        this.chunkSizeMB = chunkSizeMB;
    }

    public static SplitContext of(MongoDBSourceConfig sourceConfig, TableId collectionId) {
        MongoClient mongoClient = MongoUtils.clientFor(sourceConfig);
        return new SplitContext(mongoClient, collectionId, MongoUtils.collStats(mongoClient, collectionId), sourceConfig.getSplitSize());
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    public TableId getCollectionId() {
        return this.collectionId;
    }

    public int getChunkSizeMB() {
        return this.chunkSizeMB;
    }

    public long getDocumentCount() {
        return this.collectionStats.getNumber((Object)"count", (BsonNumber)new BsonInt64(0L)).longValue();
    }

    public long getSizeInBytes() {
        return this.collectionStats.getNumber((Object)"size", (BsonNumber)new BsonInt64(0L)).longValue();
    }

    public long getAvgObjSizeInBytes() {
        return this.collectionStats.getNumber((Object)"avgObjSize", (BsonNumber)new BsonInt64(0L)).longValue();
    }

    public boolean isShardedCollection() {
        return this.collectionStats.getBoolean((Object)"sharded", BsonBoolean.FALSE).getValue();
    }
}

