/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mongodb.source.config;

import com.ververica.cdc.connectors.base.config.SourceConfig;
import com.ververica.cdc.connectors.base.options.SourceOptions;
import com.ververica.cdc.connectors.base.options.StartupOptions;
import com.ververica.cdc.connectors.base.utils.EnvironmentUtils;
import com.ververica.cdc.connectors.mongodb.source.config.MongoDBSourceConfig;
import com.ververica.cdc.connectors.mongodb.source.config.MongoDBSourceOptions;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;

@Internal
public class MongoDBSourceConfigFactory
implements SourceConfig.Factory<MongoDBSourceConfig> {
    private static final long serialVersionUID = 1L;
    private String scheme = (String)MongoDBSourceOptions.SCHEME.defaultValue();
    private String hosts;
    private String username;
    private String password;
    private List<String> databaseList;
    private List<String> collectionList;
    private String connectionOptions;
    private Integer batchSize = (Integer)MongoDBSourceOptions.BATCH_SIZE.defaultValue();
    private Integer pollAwaitTimeMillis = (Integer)MongoDBSourceOptions.POLL_AWAIT_TIME_MILLIS.defaultValue();
    private Integer pollMaxBatchSize = (Integer)MongoDBSourceOptions.POLL_MAX_BATCH_SIZE.defaultValue();
    private boolean updateLookup = true;
    private StartupOptions startupOptions = StartupOptions.initial();
    private Integer heartbeatIntervalMillis = (Integer)MongoDBSourceOptions.HEARTBEAT_INTERVAL_MILLIS.defaultValue();
    private Integer splitMetaGroupSize = (Integer)SourceOptions.CHUNK_META_GROUP_SIZE.defaultValue();
    private Integer splitSizeMB = (Integer)MongoDBSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE_MB.defaultValue();
    private boolean closeIdleReaders = false;

    public MongoDBSourceConfigFactory scheme(String scheme) {
        Preconditions.checkArgument(("mongodb".equals(scheme) || "mongodb+srv".equals(scheme) ? 1 : 0) != 0, (Object)String.format("The scheme should either be %s or %s", "mongodb", "mongodb+srv"));
        this.scheme = scheme;
        return this;
    }

    public MongoDBSourceConfigFactory hosts(String hosts) {
        this.hosts = hosts;
        return this;
    }

    public MongoDBSourceConfigFactory connectionOptions(String connectionOptions) {
        this.connectionOptions = connectionOptions;
        return this;
    }

    public MongoDBSourceConfigFactory username(String username) {
        this.username = username;
        return this;
    }

    public MongoDBSourceConfigFactory password(String password) {
        this.password = password;
        return this;
    }

    public MongoDBSourceConfigFactory databaseList(String ... databases) {
        this.databaseList = Arrays.asList(databases);
        return this;
    }

    public MongoDBSourceConfigFactory collectionList(String ... collections) {
        this.collectionList = Arrays.asList(collections);
        return this;
    }

    public MongoDBSourceConfigFactory batchSize(int batchSize) {
        Preconditions.checkArgument((batchSize >= 0 ? 1 : 0) != 0);
        this.batchSize = batchSize;
        return this;
    }

    public MongoDBSourceConfigFactory pollAwaitTimeMillis(int pollAwaitTimeMillis) {
        Preconditions.checkArgument((pollAwaitTimeMillis > 0 ? 1 : 0) != 0);
        this.pollAwaitTimeMillis = pollAwaitTimeMillis;
        return this;
    }

    public MongoDBSourceConfigFactory pollMaxBatchSize(int pollMaxBatchSize) {
        Preconditions.checkArgument((pollMaxBatchSize > 0 ? 1 : 0) != 0);
        this.pollMaxBatchSize = pollMaxBatchSize;
        return this;
    }

    public MongoDBSourceConfigFactory startupOptions(StartupOptions startupOptions) {
        Preconditions.checkNotNull((Object)startupOptions);
        switch (startupOptions.startupMode) {
            case INITIAL: 
            case LATEST_OFFSET: 
            case TIMESTAMP: {
                this.startupOptions = startupOptions;
                return this;
            }
        }
        throw new IllegalArgumentException("Unsupported startup mode " + startupOptions.startupMode);
    }

    public MongoDBSourceConfigFactory heartbeatIntervalMillis(int heartbeatIntervalMillis) {
        Preconditions.checkArgument((heartbeatIntervalMillis >= 0 ? 1 : 0) != 0);
        this.heartbeatIntervalMillis = heartbeatIntervalMillis;
        return this;
    }

    public MongoDBSourceConfigFactory splitSizeMB(int splitSizeMB) {
        Preconditions.checkArgument((splitSizeMB > 0 ? 1 : 0) != 0);
        this.splitSizeMB = splitSizeMB;
        return this;
    }

    public MongoDBSourceConfigFactory splitMetaGroupSize(int splitMetaGroupSize) {
        this.splitMetaGroupSize = splitMetaGroupSize;
        return this;
    }

    public MongoDBSourceConfigFactory closeIdleReaders(boolean closeIdleReaders) {
        this.closeIdleReaders = closeIdleReaders;
        return this;
    }

    public MongoDBSourceConfig create(int subtaskId) {
        EnvironmentUtils.checkSupportCheckpointsAfterTasksFinished((boolean)this.closeIdleReaders);
        return new MongoDBSourceConfig(this.scheme, this.hosts, this.username, this.password, this.databaseList, this.collectionList, this.connectionOptions, this.batchSize, this.pollAwaitTimeMillis, this.pollMaxBatchSize, this.updateLookup, this.startupOptions, this.heartbeatIntervalMillis, this.splitMetaGroupSize, this.splitSizeMB, this.closeIdleReaders);
    }
}

