/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.abbreviation.internal;

import com.vladsch.flexmark.ast.DoNotDecorate;
import com.vladsch.flexmark.ast.DoNotLinkDecorate;
import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ext.abbreviation.Abbreviation;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationBlock;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationExtension;
import com.vladsch.flexmark.ext.abbreviation.internal.AbbreviationRepository;
import com.vladsch.flexmark.ext.autolink.internal.AutolinkNodePostProcessor;
import com.vladsch.flexmark.parser.PostProcessorFactory;
import com.vladsch.flexmark.parser.block.NodePostProcessor;
import com.vladsch.flexmark.parser.block.NodePostProcessorFactory;
import com.vladsch.flexmark.util.NodeTracker;
import com.vladsch.flexmark.util.html.Escaping;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AbbreviationNodePostProcessor
extends NodePostProcessor {
    private Pattern abbreviations = null;
    private HashMap<String, BasedSequence> abbreviationMap = null;

    private AbbreviationNodePostProcessor(Document document) {
        this.computeAbbreviations(document);
    }

    private void computeAbbreviations(Document document) {
        AbbreviationRepository abbrRepository = (AbbreviationRepository)((Object)document.get(AbbreviationExtension.ABBREVIATIONS));
        if (!abbrRepository.isEmpty()) {
            this.abbreviationMap = new HashMap();
            StringBuilder sb = new StringBuilder();
            ArrayList abbreviations = new ArrayList(abbrRepository.keySet());
            Collections.sort(abbreviations, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o2.compareTo(o1);
                }
            });
            for (String abbr : abbreviations) {
                BasedSequence abbreviation;
                AbbreviationBlock abbreviationBlock = (AbbreviationBlock)((Object)abbrRepository.get(abbr));
                if (abbr.isEmpty() || (abbreviation = abbreviationBlock.getAbbreviation()).isEmpty()) continue;
                this.abbreviationMap.put(abbr, abbreviation);
                if (sb.length() > 0) {
                    sb.append("|");
                }
                if (Character.isLetterOrDigit(abbr.charAt(0))) {
                    sb.append("\\b");
                }
                sb.append("\\Q").append(abbr).append("\\E");
                if (!Character.isLetterOrDigit(abbr.charAt(abbr.length() - 1))) continue;
                sb.append("\\b");
            }
            if (sb.length() > 0) {
                this.abbreviations = Pattern.compile(sb.toString());
            }
        }
    }

    public void process(NodeTracker state, Node node) {
        TextBase textBase;
        if (this.abbreviations == null) {
            return;
        }
        BasedSequence original = node.getChars();
        ReplacedTextMapper textMapper = new ReplacedTextMapper(original);
        BasedSequence literal = Escaping.unescape((BasedSequence)original, (ReplacedTextMapper)textMapper);
        Matcher m = this.abbreviations.matcher((CharSequence)literal);
        int lastEscaped = 0;
        boolean wrapInTextBase = !(node.getParent() instanceof TextBase);
        TextBase textBase2 = textBase = wrapInTextBase ? null : (TextBase)node.getParent();
        while (m.find()) {
            if (!this.abbreviationMap.containsKey(m.group(0))) continue;
            BasedSequence abbreviation = this.abbreviationMap.get(m.group(0));
            BasedSequence toDecorateText = literal.subSequence(m.start(0), m.end(0));
            int startOffset = textMapper.originalOffset(m.start(0));
            int endOffset = textMapper.originalOffset(m.end(0));
            if (wrapInTextBase) {
                wrapInTextBase = false;
                textBase = new TextBase(original);
                node.insertBefore((Node)textBase);
                state.nodeAdded((Node)textBase);
            }
            if (startOffset != lastEscaped) {
                BasedSequence escapedChars = original.subSequence(lastEscaped, startOffset);
                Text node1 = new Text(escapedChars);
                textBase.appendChild((Node)node1);
                state.nodeAdded((Node)node1);
            }
            BasedSequence origToDecorateText = original.subSequence(startOffset, endOffset);
            Abbreviation decorationNode = new Abbreviation(origToDecorateText, abbreviation);
            textBase.appendChild((Node)decorationNode);
            state.nodeAdded((Node)decorationNode);
            lastEscaped = endOffset;
        }
        if (lastEscaped > 0) {
            if (lastEscaped != original.length()) {
                BasedSequence escapedChars = original.subSequence(lastEscaped, original.length());
                Text node1 = new Text(escapedChars);
                textBase.appendChild((Node)node1);
                state.nodeAdded((Node)node1);
            }
            node.unlink();
            state.nodeRemoved(node);
        }
    }

    public static class Factory
    extends NodePostProcessorFactory {
        public Set<Class<? extends PostProcessorFactory>> getAfterDependents() {
            HashSet<Class<? extends PostProcessorFactory>> set = new HashSet<Class<? extends PostProcessorFactory>>();
            set.add(AutolinkNodePostProcessor.Factory.class);
            return set;
        }

        public Factory() {
            super(false);
            this.addNodeWithExclusions(Text.class, new Class[]{DoNotDecorate.class, DoNotLinkDecorate.class});
        }

        public NodePostProcessor create(Document document) {
            return new AbbreviationNodePostProcessor(document);
        }
    }
}

