/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.data.AuthenticatorResponse;
import com.webauthn4j.data.PublicKeyCredentialType;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.ExtensionClientOutput;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.Base64UrlUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

public class PublicKeyCredential<R extends AuthenticatorResponse, E extends ExtensionClientOutput<?>>
implements Serializable {
    private final String id;
    private final byte[] rawId;
    private final R authenticatorResponse;
    private final AuthenticationExtensionsClientOutputs<E> clientExtensionResults;

    public PublicKeyCredential(byte[] credentialId, R authenticatorResponse, AuthenticationExtensionsClientOutputs<E> clientExtensionResults) {
        this.id = Base64UrlUtil.encodeToString((byte[])credentialId);
        this.rawId = credentialId;
        this.authenticatorResponse = authenticatorResponse;
        this.clientExtensionResults = clientExtensionResults;
    }

    public String getType() {
        return PublicKeyCredentialType.PUBLIC_KEY.getValue();
    }

    public String getId() {
        return this.id;
    }

    public byte[] getRawId() {
        return ArrayUtil.clone((byte[])this.rawId);
    }

    public R getAuthenticatorResponse() {
        return this.authenticatorResponse;
    }

    public AuthenticationExtensionsClientOutputs<E> getClientExtensionResults() {
        return this.clientExtensionResults;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKeyCredential that = (PublicKeyCredential)o;
        return Objects.equals(this.id, that.id) && Arrays.equals(this.rawId, that.rawId) && Objects.equals(this.authenticatorResponse, that.authenticatorResponse) && Objects.equals(this.clientExtensionResults, that.clientExtensionResults);
    }

    public int hashCode() {
        int result = Objects.hash(this.id, this.authenticatorResponse, this.clientExtensionResults);
        result = 31 * result + Arrays.hashCode(this.rawId);
        return result;
    }
}

