/*
 * Decompiled with CFR 0.152.
 */
package com.xqbase.etcd4j;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.xqbase.etcd4j.EtcdClientException;
import com.xqbase.etcd4j.EtcdNode;
import com.xqbase.etcd4j.EtcdResult;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class EtcdClient {
    private static final CloseableHttpAsyncClient httpClient = EtcdClient.buildHttpClient();
    private static final Gson gson = new GsonBuilder().create();
    private static final String URI_PREFIX = "v2/keys";
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String RETRY_COUNTER_HEADER = "retry-count";
    private static final int DEFAULT_CONNECTION_REQUEST_TIMEOUT = 10000;
    private static final int DEFAULT_CONNECT_TIMEOUT = 10000;
    private static final int DEFAULT_SOCKET_TIMEOUT = 10000;
    private static final int FUTURE_TIMEOUT = 20000;
    private static final int MAX_RETRY_COUNT = 5;
    private final URI baseUri;
    private final ExecutorService delegateAsyncTransformer = Executors.newCachedThreadPool(new DaemonThreadFactory());
    private final ListeningExecutorService transformerPool = MoreExecutors.listeningDecorator((ExecutorService)this.delegateAsyncTransformer);

    private static CloseableHttpAsyncClient buildHttpClient() {
        RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectionRequestTimeout(10000).setConnectTimeout(10000).setSocketTimeout(10000).build();
        CloseableHttpAsyncClient httpAsyncClient = HttpAsyncClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
        httpAsyncClient.start();
        return httpAsyncClient;
    }

    public EtcdClient(URI uri) {
        String url = uri.toString();
        if (!url.endsWith("/")) {
            url = url + "/";
            uri = URI.create(url);
        }
        this.baseUri = uri;
    }

    public String get(String key) throws EtcdClientException {
        Preconditions.checkNotNull((Object)key, (Object)"key can't be null");
        URI uri = this.buildUriWithKeyAndParams(key, null);
        HttpGet httpGet = new HttpGet(uri);
        EtcdResult result = this.syncExecute((HttpUriRequest)httpGet, new int[]{200, 404}, 100);
        if (result.isError() && result.errorCode == 100) {
            return null;
        }
        return result.node != null ? result.node.value : null;
    }

    public void set(String key, String value) throws EtcdClientException {
        this.set(key, value, null);
    }

    public void set(String key, String value, Integer ttl) throws EtcdClientException {
        this.set(key, value, ttl, null);
    }

    public void set(String key, String value, Integer ttl, Boolean prevExist) throws EtcdClientException {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)value);
        ArrayList list = Lists.newArrayList();
        list.add(new BasicNameValuePair("value", value));
        if (ttl != null) {
            list.add(new BasicNameValuePair("ttl", String.valueOf(ttl)));
        }
        if (prevExist != null) {
            list.add(new BasicNameValuePair("prevExist", String.valueOf(prevExist)));
        }
        this.put(key, list, null, new int[]{200, 201}, new int[0]);
    }

    public void delete(String key) throws EtcdClientException {
        Preconditions.checkNotNull((Object)key);
        URI uri = this.buildUriWithKeyAndParams(key, null);
        HttpDelete delete = new HttpDelete(uri);
        this.syncExecute((HttpUriRequest)delete, new int[]{200, 404}, new int[0]);
    }

    public void createDir(String key) throws EtcdClientException {
        this.createDir(key, null);
    }

    public void createDir(String key, Integer ttl) throws EtcdClientException {
        this.createDir(key, ttl, null);
    }

    public void createDir(String key, Integer ttl, Boolean prevExist) throws EtcdClientException {
        Preconditions.checkNotNull((Object)key);
        ArrayList data = Lists.newArrayList();
        data.add(new BasicNameValuePair("dir", String.valueOf(true)));
        if (ttl != null) {
            data.add(new BasicNameValuePair("ttl", String.valueOf(ttl)));
        }
        if (prevExist != null) {
            data.add(new BasicNameValuePair("prevExist", String.valueOf(prevExist)));
        }
        this.put(key, data, null, new int[]{200, 201}, new int[0]);
    }

    public List<EtcdNode> listDir(String key) throws EtcdClientException {
        return this.listDir(key, false);
    }

    public List<EtcdNode> listDir(String key, Boolean recursive) throws EtcdClientException {
        URI uri;
        HttpGet httpGet;
        EtcdResult result;
        Preconditions.checkNotNull((Object)key);
        HashMap<String, String> params = new HashMap<String, String>();
        if (recursive.booleanValue()) {
            params.put("recursive", String.valueOf(true));
        }
        if ((result = this.syncExecute((HttpUriRequest)(httpGet = new HttpGet(uri = this.buildUriWithKeyAndParams(key, params))), new int[]{200, 404}, 100)) == null || result.node == null) {
            return null;
        }
        return result.node.nodes;
    }

    public void deleteDir(String key, Boolean recursive) throws EtcdClientException {
        Preconditions.checkNotNull((Object)key);
        HashMap<String, String> params = new HashMap<String, String>();
        if (recursive.booleanValue()) {
            params.put("recursive", String.valueOf(true));
        } else {
            params.put("dir", String.valueOf(true));
        }
        URI uri = this.buildUriWithKeyAndParams(key, params);
        HttpDelete httpDelete = new HttpDelete(uri);
        this.syncExecute((HttpUriRequest)httpDelete, new int[]{200, 403}, new int[0]);
    }

    public EtcdResult cas(String key, String value, Map<String, String> params) throws EtcdClientException {
        ArrayList data = Lists.newArrayList();
        data.add(new BasicNameValuePair("value", value));
        return this.put(key, data, params, new int[]{200, 412}, 101, 105);
    }

    public EtcdResult cad(String key, Map<String, String> params) throws EtcdClientException {
        URI uri = this.buildUriWithKeyAndParams(key, params);
        HttpDelete httpDelete = new HttpDelete(uri);
        return this.syncExecute((HttpUriRequest)httpDelete, new int[]{200, 412}, 101);
    }

    public ListenableFuture<EtcdResult> watch(String key) {
        return this.watch(key, null, false);
    }

    public ListenableFuture<EtcdResult> watch(String key, Long index, boolean recursive) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("wait", String.valueOf(true));
        if (index != null) {
            params.put("waitIndex", String.valueOf(index));
        }
        if (recursive) {
            params.put("recursive", String.valueOf(recursive));
        }
        URI uri = this.buildUriWithKeyAndParams(key, params);
        HttpGet httpGet = new HttpGet(uri);
        return this.asyncExecute((HttpUriRequest)httpGet, new int[]{200}, new int[0]);
    }

    private EtcdResult put(String key, List<BasicNameValuePair> data, Map<String, String> params, int[] expectedHttpStatusCodes, int ... expectedErrorCodes) throws EtcdClientException {
        URI uri = this.buildUriWithKeyAndParams(key, params);
        HttpPut httpPut = new HttpPut(uri);
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(data, Charsets.UTF_8);
        httpPut.setEntity((HttpEntity)entity);
        return this.syncExecute((HttpUriRequest)httpPut, expectedHttpStatusCodes, expectedErrorCodes);
    }

    private EtcdResult syncExecute(HttpUriRequest request, int[] expectedHttpStatusCodes, int ... exceptedErrorCodes) throws EtcdClientException {
        try {
            return (EtcdResult)this.asyncExecute(request, expectedHttpStatusCodes, exceptedErrorCodes).get(20000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new EtcdClientException("InterruptedException", e);
        }
        catch (TimeoutException e) {
            throw new EtcdClientException("TimeoutException", e);
        }
        catch (ExecutionException e) {
            throw this.unwrap(e);
        }
    }

    private ListenableFuture<EtcdResult> asyncExecute(HttpUriRequest request, int[] expectedHttpStatusCodes, int ... expectedErrorCodes) {
        ListenableFuture<HttpResponse> response = this.asyncExecuteHttp(request);
        return Futures.transform(response, (AsyncFunction)new AsyncTransformation(request, this.transformerPool, expectedHttpStatusCodes, expectedErrorCodes));
    }

    private ListenableFuture<HttpResponse> asyncExecuteHttp(HttpUriRequest request) {
        final SettableFuture future = SettableFuture.create();
        httpClient.execute(request, (FutureCallback)new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse httpResponse) {
                future.set((Object)httpResponse);
            }

            public void failed(Exception e) {
                future.setException((Throwable)e);
            }

            public void cancelled() {
                future.setException((Throwable)new InterruptedException());
            }
        });
        return future;
    }

    private EtcdClientException unwrap(ExecutionException e) {
        Throwable cause = e.getCause();
        if (cause instanceof EtcdClientException) {
            return (EtcdClientException)cause;
        }
        return new EtcdClientException("Failed to execute request", e);
    }

    private EtcdResult parseCEtcdResult(String json) throws EtcdClientException {
        EtcdResult result;
        try {
            result = (EtcdResult)gson.fromJson(json, EtcdResult.class);
        }
        catch (JsonParseException e) {
            throw new EtcdClientException("Error parsing response", e);
        }
        return result;
    }

    private static void close(HttpResponse response) {
        if (response == null) {
            return;
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            EntityUtils.consumeQuietly((HttpEntity)entity);
        }
    }

    private static boolean contains(int[] exceptedCodes, int code) {
        for (int exceptedCode : exceptedCodes) {
            if (exceptedCode != code) continue;
            return true;
        }
        return false;
    }

    private URI buildUriWithKeyAndParams(String key, Map<String, String> params) {
        String url;
        StringBuilder sb = new StringBuilder();
        sb.append(URI_PREFIX);
        if (key.startsWith("/")) {
            key = key.substring(1);
        }
        for (String token : Splitter.on((String)"/").split((CharSequence)key)) {
            sb.append("/").append(EtcdClient.urlEscape(token));
        }
        if (params != null) {
            sb.append("?");
            for (String str : params.keySet()) {
                sb.append(EtcdClient.urlEscape(str)).append("=").append(EtcdClient.urlEscape(params.get(str)));
                sb.append("&");
            }
        }
        if ((url = sb.toString()).endsWith("&")) {
            url = url.substring(0, url.length() - 1);
        }
        return this.baseUri.resolve(url);
    }

    private static String urlEscape(String url) {
        try {
            return URLEncoder.encode(url, DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException();
        }
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    }

    private class AsyncTransformation
    implements AsyncFunction<HttpResponse, EtcdResult> {
        private final ListeningExecutorService transformPool;
        private final HttpUriRequest request;
        private final int[] expectedHttpStatusCodes;
        private final int[] exceptedErrorCodes;

        AsyncTransformation(HttpUriRequest request, ListeningExecutorService transformPool, int[] expectedHttpStatusCodes, int ... expectedErrorCodes) {
            this.request = request;
            this.transformPool = transformPool;
            this.expectedHttpStatusCodes = expectedHttpStatusCodes;
            this.exceptedErrorCodes = expectedErrorCodes;
        }

        public ListenableFuture<EtcdResult> apply(HttpResponse response) throws Exception {
            if (response.getStatusLine().getStatusCode() == 500) {
                Header retryHeader = this.request.getFirstHeader(EtcdClient.RETRY_COUNTER_HEADER);
                if (retryHeader != null) {
                    Integer count = Integer.parseInt(retryHeader.getValue());
                    if (count > 0) {
                        this.request.removeHeader(retryHeader);
                        count = count - 1;
                        this.request.addHeader(EtcdClient.RETRY_COUNTER_HEADER, String.valueOf(count));
                        return EtcdClient.this.asyncExecute(this.request, this.expectedHttpStatusCodes, new int[0]);
                    }
                } else {
                    this.request.addHeader(EtcdClient.RETRY_COUNTER_HEADER, String.valueOf(5));
                    return EtcdClient.this.asyncExecute(this.request, this.expectedHttpStatusCodes, new int[0]);
                }
            }
            return this.transformPool.submit((Callable)new TransformerWorker(response, this.expectedHttpStatusCodes, this.exceptedErrorCodes));
        }

        private class TransformerWorker
        implements Callable<EtcdResult> {
            private final HttpResponse response;
            private final int[] expectedHttpStatusCodes;
            private final int[] expectedErrorCodes;

            private TransformerWorker(HttpResponse response, int[] expectedHttpStatusCodes, int ... expectedErrorCodes) {
                this.response = response;
                this.expectedHttpStatusCodes = expectedHttpStatusCodes;
                this.expectedErrorCodes = expectedErrorCodes;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EtcdResult call() throws Exception {
                try {
                    StatusLine statusLine = this.response.getStatusLine();
                    int statusCode = statusLine.getStatusCode();
                    String json = null;
                    if (this.response.getEntity() != null) {
                        try {
                            json = EntityUtils.toString((HttpEntity)this.response.getEntity(), (String)EtcdClient.DEFAULT_CHARSET);
                        }
                        catch (IOException e) {
                            throw new EtcdClientException("Error reading response", e);
                        }
                    }
                    if (!(EtcdClient.contains(this.expectedHttpStatusCodes, statusCode) || statusCode == 404 && json != null)) {
                        throw new EtcdClientException("Error response from etcd: " + statusLine.getReasonPhrase(), statusCode);
                    }
                    if (json != null) {
                        EtcdResult result = EtcdClient.this.parseCEtcdResult(json);
                        if (result.isError() && !EtcdClient.contains(this.expectedErrorCodes, result.errorCode)) {
                            throw new EtcdClientException(result.message, result);
                        }
                        EtcdResult etcdResult = result;
                        return etcdResult;
                    }
                }
                finally {
                    EtcdClient.close(this.response);
                }
                return null;
            }
        }
    }
}

