/*
 * Decompiled with CFR 0.152.
 */
package com.yamanyar.mvn.plugin;

import com.yamanyar.mvn.plugin.utils.WildcardMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestrictionConfigurationFactory {
    public static Map<WildcardMatcher, Set<WildcardMatcher>> produceConfiguration(String[] restrictions, Log log) {
        HashMap<WildcardMatcher, Set<WildcardMatcher>> restrictionsMap = new HashMap<WildcardMatcher, Set<WildcardMatcher>>();
        for (String restriction : restrictions) {
            String[] toList;
            String token = " to ";
            int i = restriction.indexOf(token);
            if (i < 0 || i + 2 > restriction.length()) {
                throw new IllegalArgumentException("Please check restriction configuration:" + restriction);
            }
            String fromPart = restriction.substring(0, i);
            String toPart = restriction.substring(i + token.length());
            ArrayList<WildcardMatcher> fromExceptions = new ArrayList<WildcardMatcher>();
            ArrayList<WildcardMatcher> toExceptions = new ArrayList<WildcardMatcher>();
            String[] fromList = fromPart.split(",");
            for (String to : toList = toPart.split(",")) {
                String toString = to.trim();
                if ("!".equals(toString)) {
                    throw new IllegalArgumentException("Please check restriction configuration: (! must be followed by a pattern like !com.*)" + restriction);
                }
                if (toString.startsWith("!")) {
                    toExceptions.add(new WildcardMatcher(toString.substring(1), log));
                    continue;
                }
                for (String from : fromList) {
                    String fromString = from.trim();
                    if ("!".equals(fromString)) {
                        throw new IllegalArgumentException("Please check restriction configuration: (! must be followed by a pattern like !com.*)" + restriction);
                    }
                    if (fromString.startsWith("!")) {
                        fromExceptions.add(new WildcardMatcher(fromString.substring(1), log));
                        continue;
                    }
                    WildcardMatcher fromMatcher = new WildcardMatcher(fromString, log);
                    fromMatcher.setExceptions(fromExceptions);
                    Set<WildcardMatcher> toMatcherSet = RestrictionConfigurationFactory.getToMatcherSet(restrictionsMap, fromMatcher);
                    WildcardMatcher toMatcher = new WildcardMatcher(toString, log);
                    toMatcher.setExceptions(toExceptions);
                    toMatcherSet.add(toMatcher);
                }
            }
        }
        log.info((CharSequence)"###### Restriction Rules (begins) ######");
        for (Map.Entry entry : restrictionsMap.entrySet()) {
            WildcardMatcher from = (WildcardMatcher)entry.getKey();
            for (WildcardMatcher to : (Set)entry.getValue()) {
                String exceptFrom = from.getExceptions();
                String exceptTo = from.getExceptions();
                exceptFrom = exceptFrom == null ? "" : " (except " + exceptFrom + ")";
                exceptTo = exceptTo == null ? "" : " (except " + exceptTo + ")";
                String message = String.format("[%d-%d] Access from %s%s to %s%s will be not allowed.", from.getRuleNo(), to.getRuleNo(), from, exceptFrom, to, exceptTo);
                log.info((CharSequence)message);
            }
        }
        log.info((CharSequence)"###### Restriction Rules (ends)   ######");
        return restrictionsMap;
    }

    private static Set<WildcardMatcher> getToMatcherSet(Map<WildcardMatcher, Set<WildcardMatcher>> restrictionsMap, WildcardMatcher fromMatcher) {
        Set<WildcardMatcher> toMatcherSet = restrictionsMap.get(fromMatcher);
        if (toMatcherSet == null) {
            toMatcherSet = new HashSet<WildcardMatcher>();
            restrictionsMap.put(fromMatcher, toMatcherSet);
        }
        return toMatcherSet;
    }
}

