/*
 * Decompiled with CFR 0.152.
 */
package com.yamanyar.mvn.plugin.utils;

import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.maven.plugin.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WildcardMatcher {
    private int ruleNo = 0;
    private static int ruleCounter = 0;
    private final Pattern pattern;
    private final Pattern methodPattern;
    private final String wildcardString;
    private final Log log;
    private List<WildcardMatcher> exceptions;

    public WildcardMatcher(String wildcardString, Log log) {
        this.log = log;
        this.ruleNo = ++ruleCounter;
        if (wildcardString == null) {
            throw new IllegalArgumentException("How can I match with null?");
        }
        this.wildcardString = wildcardString;
        if (this.isMethod()) {
            this.pattern = Pattern.compile(this.wildcardToRegex(wildcardString.substring(0, wildcardString.lastIndexOf(46))));
            this.methodPattern = Pattern.compile(this.wildcardToRegex(wildcardString));
        } else {
            this.pattern = Pattern.compile(this.wildcardToRegex(wildcardString));
            this.methodPattern = null;
        }
    }

    public boolean isMethod() {
        return this.wildcardString.endsWith("()");
    }

    public boolean matchMethod(String testString) {
        return this.matchAgainstPattern(testString, this.methodPattern);
    }

    public boolean match(String testString) {
        return this.matchAgainstPattern(testString, this.pattern);
    }

    private boolean matchAgainstPattern(String testString, Pattern patternToBeMatched) {
        boolean matchesPattern = patternToBeMatched.matcher(testString).matches();
        if (matchesPattern && this.exceptions != null) {
            for (WildcardMatcher exception : this.exceptions) {
                if (!exception.match(testString)) continue;
                this.log.debug((CharSequence)String.format("An exception to a restriction (%s of rule %d) matched %s.", this.wildcardString, this.ruleNo, testString));
                return false;
            }
        }
        return matchesPattern;
    }

    private String wildcardToRegex(String wildcard) {
        StringBuffer s = new StringBuffer(wildcard.length());
        s.append('^');
        int is = wildcard.length();
        block5: for (int i = 0; i < is; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    continue block5;
                }
                case '?': {
                    s.append(".");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\");
                    s.append(c);
                    continue block5;
                }
                default: {
                    s.append(c);
                }
            }
        }
        s.append('$');
        return s.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WildcardMatcher that = (WildcardMatcher)o;
        return this.wildcardString.equals(that.wildcardString);
    }

    public int hashCode() {
        return this.wildcardString.hashCode();
    }

    public String toString() {
        return this.wildcardString;
    }

    public int getRuleNo() {
        return this.ruleNo;
    }

    public void setExceptions(List<WildcardMatcher> exceptions) {
        this.exceptions = exceptions;
    }

    public String getExceptions() {
        if (this.exceptions == null || this.exceptions.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<WildcardMatcher> iterator = this.exceptions.iterator();
        while (iterator.hasNext()) {
            WildcardMatcher next = iterator.next();
            sb.append(next.wildcardString);
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

