/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.guice;

import com.yammer.metrics.annotation.Timed;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

class TimedInterceptor
implements MethodInterceptor {
    private final Timer timer;

    static MethodInterceptor forMethod(MetricsRegistry metricsRegistry, Class<?> klass, Method method) {
        Timed annotation = method.getAnnotation(Timed.class);
        if (annotation != null) {
            String group = MetricName.chooseGroup((String)annotation.group(), klass);
            String type = MetricName.chooseType((String)annotation.type(), klass);
            String name = MetricName.chooseName((String)annotation.name(), (Method)method);
            MetricName metricName = new MetricName(group, type, name);
            Timer timer = metricsRegistry.newTimer(metricName, annotation.durationUnit(), annotation.rateUnit());
            return new TimedInterceptor(timer);
        }
        return null;
    }

    private TimedInterceptor(Timer timer) {
        this.timer = timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        TimerContext ctx = this.timer.time();
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            ctx.stop();
        }
    }
}

