/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.extension.uvm.KeyProtectionType;
import com.yubico.webauthn.extension.uvm.MatcherProtectionType;
import com.yubico.webauthn.extension.uvm.UserVerificationMethod;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Extensions {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Extensions.class);

    @Generated
    private Extensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class Uvm {
        static final String EXTENSION_ID = "uvm";

        static Optional<List<UvmEntry>> parseAuthenticatorExtensionOutput(CBORObject cbor) {
            if (Uvm.validateAuthenticatorExtensionOutput(cbor)) {
                return Optional.of(cbor.get(EXTENSION_ID).getValues().stream().map(uvmEntry -> new UvmEntry(UserVerificationMethod.fromValue(uvmEntry.get(0).AsInt32Value()), KeyProtectionType.fromValue(uvmEntry.get(1).AsNumber().ToInt16IfExact()), MatcherProtectionType.fromValue(uvmEntry.get(2).AsNumber().ToInt16IfExact()))).collect(Collectors.toList()));
            }
            return Optional.empty();
        }

        private static boolean validateAuthenticatorExtensionOutput(CBORObject extensions) {
            if (!extensions.ContainsKey(EXTENSION_ID)) {
                return false;
            }
            CBORObject uvm = extensions.get(EXTENSION_ID);
            if (uvm.getType() != CBORType.Array) {
                log.debug("Invalid CBOR type for \"{}\" extension output: expected array, was: {}", (Object)EXTENSION_ID, (Object)uvm.getType());
                return false;
            }
            if (uvm.size() < 1 || uvm.size() > 3) {
                log.debug("Invalid length \"{}\" extension output array: expected 1 to 3 (inclusive), was: {}", (Object)EXTENSION_ID, (Object)uvm.size());
                return false;
            }
            for (CBORObject entry : uvm.getValues()) {
                if (entry.getType() != CBORType.Array) {
                    log.debug("Invalid CBOR type for uvmEntry: expected array, was: {}", (Object)entry.getType());
                    return false;
                }
                if (entry.size() != 3) {
                    log.debug("Invalid length for uvmEntry: expected 3, was: {}", (Object)entry.size());
                    return false;
                }
                for (CBORObject i : entry.getValues()) {
                    if (i.isNumber() && i.AsNumber().IsInteger()) continue;
                    log.debug("Invalid type for uvmEntry element: expected integer, was: {}", (Object)i.getType());
                    return false;
                }
            }
            return true;
        }

        public static final class UvmEntry {
            private final UserVerificationMethod userVerificationMethod;
            private final KeyProtectionType keyProtectionType;
            private final MatcherProtectionType matcherProtectionType;

            public UvmEntry(@JsonProperty(value="userVerificationMethod") UserVerificationMethod userVerificationMethod, @JsonProperty(value="keyProtectionType") KeyProtectionType keyProtectionType, @JsonProperty(value="matcherProtectionType") MatcherProtectionType matcherProtectionType) {
                this.userVerificationMethod = userVerificationMethod;
                this.keyProtectionType = keyProtectionType;
                this.matcherProtectionType = matcherProtectionType;
            }

            @Generated
            public UserVerificationMethod getUserVerificationMethod() {
                return this.userVerificationMethod;
            }

            @Generated
            public KeyProtectionType getKeyProtectionType() {
                return this.keyProtectionType;
            }

            @Generated
            public MatcherProtectionType getMatcherProtectionType() {
                return this.matcherProtectionType;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof UvmEntry)) {
                    return false;
                }
                UvmEntry other = (UvmEntry)o;
                UserVerificationMethod this$userVerificationMethod = this.getUserVerificationMethod();
                UserVerificationMethod other$userVerificationMethod = other.getUserVerificationMethod();
                if (this$userVerificationMethod == null ? other$userVerificationMethod != null : !((Object)((Object)this$userVerificationMethod)).equals((Object)other$userVerificationMethod)) {
                    return false;
                }
                KeyProtectionType this$keyProtectionType = this.getKeyProtectionType();
                KeyProtectionType other$keyProtectionType = other.getKeyProtectionType();
                if (this$keyProtectionType == null ? other$keyProtectionType != null : !((Object)((Object)this$keyProtectionType)).equals((Object)other$keyProtectionType)) {
                    return false;
                }
                MatcherProtectionType this$matcherProtectionType = this.getMatcherProtectionType();
                MatcherProtectionType other$matcherProtectionType = other.getMatcherProtectionType();
                return !(this$matcherProtectionType == null ? other$matcherProtectionType != null : !((Object)((Object)this$matcherProtectionType)).equals((Object)other$matcherProtectionType));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UserVerificationMethod $userVerificationMethod = this.getUserVerificationMethod();
                result = result * 59 + ($userVerificationMethod == null ? 43 : ((Object)((Object)$userVerificationMethod)).hashCode());
                KeyProtectionType $keyProtectionType = this.getKeyProtectionType();
                result = result * 59 + ($keyProtectionType == null ? 43 : ((Object)((Object)$keyProtectionType)).hashCode());
                MatcherProtectionType $matcherProtectionType = this.getMatcherProtectionType();
                result = result * 59 + ($matcherProtectionType == null ? 43 : ((Object)((Object)$matcherProtectionType)).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Extensions.Uvm.UvmEntry(userVerificationMethod=" + (Object)((Object)this.getUserVerificationMethod()) + ", keyProtectionType=" + (Object)((Object)this.getKeyProtectionType()) + ", matcherProtectionType=" + (Object)((Object)this.getMatcherProtectionType()) + ")";
            }
        }
    }

    public static class LargeBlob {
        static final String EXTENSION_ID = "largeBlob";

        public static final class LargeBlobAuthenticationOutput {
            @JsonProperty
            private final ByteArray blob;
            @JsonProperty
            private final Boolean written;

            @JsonCreator
            LargeBlobAuthenticationOutput(@JsonProperty(value="blob") ByteArray blob, @JsonProperty(value="written") Boolean written) {
                this.blob = blob;
                this.written = written;
            }

            public Optional<ByteArray> getBlob() {
                return Optional.ofNullable(this.blob);
            }

            public Optional<Boolean> getWritten() {
                return Optional.ofNullable(this.written);
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LargeBlobAuthenticationOutput)) {
                    return false;
                }
                LargeBlobAuthenticationOutput other = (LargeBlobAuthenticationOutput)o;
                Optional<Boolean> this$written = this.getWritten();
                Optional<Boolean> other$written = other.getWritten();
                if (this$written == null ? other$written != null : !((Object)this$written).equals(other$written)) {
                    return false;
                }
                Optional<ByteArray> this$blob = this.getBlob();
                Optional<ByteArray> other$blob = other.getBlob();
                return !(this$blob == null ? other$blob != null : !((Object)this$blob).equals(other$blob));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Optional<Boolean> $written = this.getWritten();
                result = result * 59 + ($written == null ? 43 : ((Object)$written).hashCode());
                Optional<ByteArray> $blob = this.getBlob();
                result = result * 59 + ($blob == null ? 43 : ((Object)$blob).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Extensions.LargeBlob.LargeBlobAuthenticationOutput(blob=" + this.getBlob() + ", written=" + this.getWritten() + ")";
            }
        }

        public static final class LargeBlobRegistrationOutput {
            @JsonProperty
            private final boolean supported;

            @JsonCreator
            LargeBlobRegistrationOutput(@JsonProperty(value="supported") boolean supported) {
                this.supported = supported;
            }

            @Generated
            public boolean isSupported() {
                return this.supported;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LargeBlobRegistrationOutput)) {
                    return false;
                }
                LargeBlobRegistrationOutput other = (LargeBlobRegistrationOutput)o;
                return this.isSupported() == other.isSupported();
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isSupported() ? 79 : 97);
                return result;
            }

            @Generated
            public String toString() {
                return "Extensions.LargeBlob.LargeBlobRegistrationOutput(supported=" + this.isSupported() + ")";
            }
        }

        public static final class LargeBlobAuthenticationInput {
            @JsonProperty
            private final boolean read;
            @JsonProperty
            private final ByteArray write;

            @JsonCreator
            private LargeBlobAuthenticationInput(@JsonProperty(value="read") Boolean read, @JsonProperty(value="write") ByteArray write) {
                if (read != null && read.booleanValue() && write != null) {
                    throw new IllegalArgumentException("Parameters \"read\" and \"write\" of largeBlob extension must not both be present.");
                }
                this.read = read != null && read != false;
                this.write = write;
            }

            public static LargeBlobAuthenticationInput read() {
                return new LargeBlobAuthenticationInput(true, null);
            }

            public static LargeBlobAuthenticationInput write(@NonNull ByteArray write) {
                if (write == null) {
                    throw new NullPointerException("write is marked non-null but is null");
                }
                return new LargeBlobAuthenticationInput(false, write);
            }

            public boolean getRead() {
                return this.read;
            }

            public Optional<ByteArray> getWrite() {
                return Optional.ofNullable(this.write);
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LargeBlobAuthenticationInput)) {
                    return false;
                }
                LargeBlobAuthenticationInput other = (LargeBlobAuthenticationInput)o;
                if (this.getRead() != other.getRead()) {
                    return false;
                }
                Optional<ByteArray> this$write = this.getWrite();
                Optional<ByteArray> other$write = other.getWrite();
                return !(this$write == null ? other$write != null : !((Object)this$write).equals(other$write));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.getRead() ? 79 : 97);
                Optional<ByteArray> $write = this.getWrite();
                result = result * 59 + ($write == null ? 43 : ((Object)$write).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Extensions.LargeBlob.LargeBlobAuthenticationInput(read=" + this.getRead() + ", write=" + this.getWrite() + ")";
            }
        }

        public static final class LargeBlobRegistrationInput {
            @JsonProperty
            private final LargeBlobSupport support;

            @JsonCreator
            public LargeBlobRegistrationInput(@JsonProperty(value="support") LargeBlobSupport support) {
                this.support = support;
            }

            @Generated
            public LargeBlobSupport getSupport() {
                return this.support;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LargeBlobRegistrationInput)) {
                    return false;
                }
                LargeBlobRegistrationInput other = (LargeBlobRegistrationInput)o;
                LargeBlobSupport this$support = this.getSupport();
                LargeBlobSupport other$support = other.getSupport();
                return !(this$support == null ? other$support != null : !((Object)this$support).equals(other$support));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                LargeBlobSupport $support = this.getSupport();
                result = result * 59 + ($support == null ? 43 : ((Object)$support).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Extensions.LargeBlob.LargeBlobRegistrationInput(support=" + this.getSupport() + ")";
            }

            public static final class LargeBlobSupport {
                public static final LargeBlobSupport REQUIRED = new LargeBlobSupport("required");
                public static final LargeBlobSupport PREFERRED = new LargeBlobSupport("preferred");
                @JsonValue
                private final String value;

                public static Set<LargeBlobSupport> values() {
                    return Stream.of(REQUIRED, PREFERRED).collect(Collectors.toSet());
                }

                @Generated
                public LargeBlobSupport(String value) {
                    this.value = value;
                }

                @Generated
                public String getValue() {
                    return this.value;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof LargeBlobSupport)) {
                        return false;
                    }
                    LargeBlobSupport other = (LargeBlobSupport)o;
                    String this$value = this.getValue();
                    String other$value = other.getValue();
                    return !(this$value == null ? other$value != null : !this$value.equals(other$value));
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $value = this.getValue();
                    result = result * 59 + ($value == null ? 43 : $value.hashCode());
                    return result;
                }

                @Generated
                public String toString() {
                    return "Extensions.LargeBlob.LargeBlobRegistrationInput.LargeBlobSupport(value=" + this.getValue() + ")";
                }
            }
        }
    }

    public static class CredentialProperties {
        static final String EXTENSION_ID = "credProps";

        public static final class CredentialPropertiesOutput {
            @JsonProperty(value="rk")
            private final Boolean rk;

            @JsonCreator
            CredentialPropertiesOutput(@JsonProperty(value="rk") Boolean rk) {
                this.rk = rk;
            }

            public Optional<Boolean> getRk() {
                return Optional.ofNullable(this.rk);
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CredentialPropertiesOutput)) {
                    return false;
                }
                CredentialPropertiesOutput other = (CredentialPropertiesOutput)o;
                Optional<Boolean> this$rk = this.getRk();
                Optional<Boolean> other$rk = other.getRk();
                return !(this$rk == null ? other$rk != null : !((Object)this$rk).equals(other$rk));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Optional<Boolean> $rk = this.getRk();
                result = result * 59 + ($rk == null ? 43 : ((Object)$rk).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Extensions.CredentialProperties.CredentialPropertiesOutput(rk=" + this.getRk() + ")";
            }
        }
    }

    public static class AppidExclude {
        static final String EXTENSION_ID = "appidExclude";
    }

    public static class Appid {
        static final String EXTENSION_ID = "appid";
    }
}

