/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.replication.fluent;

import com.yugabyte.core.BaseConnection;
import com.yugabyte.core.ReplicationProtocol;
import com.yugabyte.replication.PGReplicationStream;
import com.yugabyte.replication.fluent.ChainedStreamBuilder;
import com.yugabyte.replication.fluent.logical.ChainedLogicalStreamBuilder;
import com.yugabyte.replication.fluent.logical.LogicalReplicationOptions;
import com.yugabyte.replication.fluent.logical.LogicalStreamBuilder;
import com.yugabyte.replication.fluent.logical.StartLogicalReplicationCallback;
import com.yugabyte.replication.fluent.physical.ChainedPhysicalStreamBuilder;
import com.yugabyte.replication.fluent.physical.PhysicalReplicationOptions;
import com.yugabyte.replication.fluent.physical.PhysicalStreamBuilder;
import com.yugabyte.replication.fluent.physical.StartPhysicalReplicationCallback;
import java.sql.SQLException;

public class ReplicationStreamBuilder
implements ChainedStreamBuilder {
    private final BaseConnection baseConnection;

    public ReplicationStreamBuilder(BaseConnection connection) {
        this.baseConnection = connection;
    }

    @Override
    public ChainedLogicalStreamBuilder logical() {
        return new LogicalStreamBuilder(new StartLogicalReplicationCallback(){

            @Override
            public PGReplicationStream start(LogicalReplicationOptions options) throws SQLException {
                ReplicationProtocol protocol = ReplicationStreamBuilder.this.baseConnection.getReplicationProtocol();
                return protocol.startLogical(options);
            }
        });
    }

    @Override
    public ChainedPhysicalStreamBuilder physical() {
        return new PhysicalStreamBuilder(new StartPhysicalReplicationCallback(){

            @Override
            public PGReplicationStream start(PhysicalReplicationOptions options) throws SQLException {
                ReplicationProtocol protocol = ReplicationStreamBuilder.this.baseConnection.getReplicationProtocol();
                return protocol.startPhysical(options);
            }
        });
    }
}

