/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.core.registrar;

import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RetryUtils {
    private static final Logger log = LoggerFactory.getLogger(RetryUtils.class);

    RetryUtils() {
    }

    static <T> T tryInvoke(Supplier<T> action, Function<RuntimeException, Boolean> recoverableExceptionChecker, int maxTries) {
        int tries = 0;
        while (true) {
            try {
                return action.get();
            }
            catch (RuntimeException e) {
                Boolean isRecoverableException = recoverableExceptionChecker.apply(e);
                if (!isRecoverableException.booleanValue() || ++tries == maxTries) {
                    log.debug("All tries have been exhausted. Final exception is {}: {}", e.getClass(), (Object)e.getMessage());
                    throw e;
                }
                log.debug("Trying to recover from exception {}: {}", e.getClass(), (Object)e.getMessage());
                continue;
            }
            break;
        }
    }

    static void tryInvoke(Runnable action, Function<RuntimeException, Boolean> recoverableExceptionChecker, int maxTries) {
        int tries = 0;
        while (true) {
            try {
                action.run();
                return;
            }
            catch (RuntimeException e) {
                Boolean isRecoverableException = recoverableExceptionChecker.apply(e);
                if (!isRecoverableException.booleanValue() || ++tries == maxTries) {
                    log.debug("All tries have been exhausted. Final exception is {}: {}", e.getClass(), (Object)e.getMessage());
                    throw e;
                }
                log.debug("Trying to recover from exception {}: {}", e.getClass(), (Object)e.getMessage());
                continue;
            }
            break;
        }
    }
}

