/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.core.registrar;

import com.zebrunner.agent.core.annotation.TestRailCaseId;
import com.zebrunner.agent.core.registrar.RegistrationListener;
import com.zebrunner.agent.core.registrar.TestCasesRegistry;
import com.zebrunner.agent.core.registrar.descriptor.TestStartDescriptor;
import com.zebrunner.agent.core.registrar.domain.TcmType;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class TestRailCasesCollectingRegistrationListener
implements RegistrationListener {
    private final TestCasesRegistry testCasesRegistry = TestCasesRegistry.getInstance();

    TestRailCasesCollectingRegistrationListener() {
    }

    @Override
    public void onAfterTestStart(TestStartDescriptor startDescriptor) {
        TestRailCaseId[] annotations = this.getAnnotations(startDescriptor.getTestMethod());
        List<String> testCaseIds = Optional.ofNullable(annotations).map(Arrays::stream).orElseGet(Stream::empty).map(TestRailCaseId::value).flatMap(Arrays::stream).collect(Collectors.toList());
        this.testCasesRegistry.addTestCasesToCurrentTest(TcmType.TEST_RAIL, testCaseIds);
    }

    private TestRailCaseId[] getAnnotations(AnnotatedElement annotatedElement) {
        return Optional.ofNullable(annotatedElement.getAnnotation(TestRailCaseId.List.class)).map(TestRailCaseId.List::value).orElseGet(() -> this.wrapInArrayIfNonNull(annotatedElement.getAnnotation(TestRailCaseId.class)));
    }

    private TestRailCaseId[] wrapInArrayIfNonNull(TestRailCaseId annotation) {
        TestRailCaseId[] testRailCaseIdArray;
        if (annotation != null) {
            TestRailCaseId[] testRailCaseIdArray2 = new TestRailCaseId[1];
            testRailCaseIdArray = testRailCaseIdArray2;
            testRailCaseIdArray2[0] = annotation;
        } else {
            testRailCaseIdArray = null;
        }
        return testRailCaseIdArray;
    }
}

