/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.core.webdriver;

import com.zebrunner.agent.core.webdriver.PublicMethodInvocationInterceptor;
import com.zebrunner.agent.core.webdriver.QuitSessionInterceptor;
import com.zebrunner.agent.core.webdriver.StartSessionInterceptor;
import java.lang.instrument.Instrumentation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.matcher.NameMatcher;
import net.bytebuddy.pool.TypePool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverSessionsAgent {
    private static final Logger log = LoggerFactory.getLogger(DriverSessionsAgent.class);
    private static final String REMOTE_WEB_DRIVER_CLASS_MAME = "org.openqa.selenium.remote.RemoteWebDriver";
    private static final String APPIUM_WEB_DRIVER_CLASS_MAME = "io.appium.java_client.AppiumDriver";
    private static final String START_SESSION_METHOD_MAME = "startSession";
    private static final String QUIT_METHOD_MAME = "quit";
    private static final Set<String> PUBLIC_METHODS_TO_NOT_INTERCEPT = new HashSet<String>(Arrays.asList("startSession", "quit", "getSessionId", "getCapabilities", "getCommandExecutor", "wait", "equals", "hashCode", "getClass", "notify", "notifyAll", "toString"));

    public static void premain(String args, Instrumentation instrumentation) {
        try {
            new AgentBuilder.Default().with((AgentBuilder.InitializationStrategy)new AgentBuilder.InitializationStrategy.SelfInjection.Eager()).type((ElementMatcher)ElementMatchers.named((String)REMOTE_WEB_DRIVER_CLASS_MAME)).transform((builder, type, classloader, module, protectionDomain) -> DriverSessionsAgent.addInterceptors(builder)).type((ElementMatcher)ElementMatchers.named((String)APPIUM_WEB_DRIVER_CLASS_MAME)).transform((builder, type, classloader, module, protectionDomain) -> builder.method((ElementMatcher)ElementMatchers.named((String)START_SESSION_METHOD_MAME)).intercept((Implementation)MethodDelegation.to((TypeDescription)DriverSessionsAgent.startSessionInterceptor()))).installOn(instrumentation);
        }
        catch (Exception e) {
            log.error("Could not add interceptors for RemoteWebDriver", (Throwable)e);
        }
    }

    public static ElementMatcher<? super MethodDescription> isPublicMethodToIntercept() {
        return ElementMatchers.isPublic().and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isStatic())).and((ElementMatcher)ElementMatchers.not((ElementMatcher)new NameMatcher(PUBLIC_METHODS_TO_NOT_INTERCEPT::contains)));
    }

    private static DynamicType.Builder<?> addInterceptors(DynamicType.Builder<?> builder) {
        return builder.method(DriverSessionsAgent.isPublicMethodToIntercept()).intercept((Implementation)MethodDelegation.to((TypeDescription)DriverSessionsAgent.publicMethodsInterceptor())).method((ElementMatcher)ElementMatchers.named((String)START_SESSION_METHOD_MAME)).intercept((Implementation)MethodDelegation.to((TypeDescription)DriverSessionsAgent.startSessionInterceptor())).method((ElementMatcher)ElementMatchers.named((String)QUIT_METHOD_MAME)).intercept((Implementation)MethodDelegation.to((TypeDescription)DriverSessionsAgent.quitSessionInterceptor()));
    }

    private static TypeDescription publicMethodsInterceptor() {
        return TypePool.Default.ofSystemLoader().describe(PublicMethodInvocationInterceptor.class.getName()).resolve();
    }

    private static TypeDescription startSessionInterceptor() {
        return TypePool.Default.ofSystemLoader().describe(StartSessionInterceptor.class.getName()).resolve();
    }

    private static TypeDescription quitSessionInterceptor() {
        return TypePool.Default.ofSystemLoader().describe(QuitSessionInterceptor.class.getName()).resolve();
    }
}

