/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.core.webdriver;

import com.zebrunner.agent.core.registrar.TestSessionRegistrar;
import com.zebrunner.agent.core.registrar.descriptor.SessionCloseDescriptor;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuitSessionInterceptor {
    private static final Logger log = LoggerFactory.getLogger(QuitSessionInterceptor.class);
    private static final TestSessionRegistrar REGISTRAR = TestSessionRegistrar.getInstance();
    private static final Map<String, Object> CLOSED_SESSIONS = new ConcurrentHashMap<String, Object>();
    private static final Object MAP_VALUE = new Object();

    @RuntimeType
    public static void onSessionClose(@This RemoteWebDriver driver, @SuperCall Callable<Boolean> proxy) throws Exception {
        String sessionId = driver.getSessionId().toString();
        if (sessionId.length() >= 64) {
            sessionId = sessionId.substring(32);
        }
        if (CLOSED_SESSIONS.put(sessionId, MAP_VALUE) == null) {
            SessionCloseDescriptor closeDescriptor = SessionCloseDescriptor.of(sessionId);
            REGISTRAR.registerClose(closeDescriptor);
        } else {
            log.warn("Session with id {} is closed more than once.", (Object)sessionId);
        }
        proxy.call();
    }
}

