/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.core.webdriver;

import com.zebrunner.agent.core.registrar.domain.ObjectMapperImpl;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import kong.unirest.GenericType;
import kong.unirest.ObjectMapper;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class RemoteWebDriverFactory {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperImpl();
    private static final GenericType<Map<String, String>> CAPABILITIES_TYPE = new GenericType<Map<String, String>>(){};

    public static URL getSeleniumHubUrl() {
        String hubUrl = System.getenv("ZEBRUNNER_HUB_URL");
        return hubUrl != null ? new URL(hubUrl) : null;
    }

    private static URL getMandatorySeleniumHubUrl() {
        return Optional.ofNullable(RemoteWebDriverFactory.getSeleniumHubUrl()).orElseThrow(() -> new RuntimeException("Zebrunner didn't provide a selenium hub url."));
    }

    public static Capabilities getCapabilities() {
        String capabilities = System.getenv("ZEBRUNNER_CAPABILITIES");
        DesiredCapabilities desiredCapabilities = new DesiredCapabilities();
        if (capabilities != null) {
            Map capabilitiesMap = (Map)OBJECT_MAPPER.readValue(capabilities, CAPABILITIES_TYPE);
            desiredCapabilities = new DesiredCapabilities(capabilitiesMap);
        }
        return desiredCapabilities;
    }

    public static RemoteWebDriver getDriver() {
        return new RemoteWebDriver(RemoteWebDriverFactory.getMandatorySeleniumHubUrl(), RemoteWebDriverFactory.getCapabilities());
    }

    public static RemoteWebDriver getDriver(Capabilities capabilities) {
        capabilities = capabilities.merge(RemoteWebDriverFactory.getCapabilities());
        return new RemoteWebDriver(RemoteWebDriverFactory.getMandatorySeleniumHubUrl(), capabilities);
    }

    public static RemoteWebDriver getDriver(Map<String, ?> capabilitiesMap) {
        DesiredCapabilities capabilities = new DesiredCapabilities(capabilitiesMap);
        capabilities = capabilities.merge(RemoteWebDriverFactory.getCapabilities());
        return new RemoteWebDriver(RemoteWebDriverFactory.getMandatorySeleniumHubUrl(), (Capabilities)capabilities);
    }

    private RemoteWebDriverFactory() {
    }
}

