/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.testng.core;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;

public class TestInvocationContext {
    private static final Gson GSON = new Gson();
    private static final int MAX_DISPLAY_NAME_LENGTH = 255;
    private final String thread = Thread.currentThread().getName();
    private String className;
    private String methodName;
    private String displayName;
    private List<String> parameters;
    private List<String> parameterClassNames;
    private int dataProviderIndex;
    private int instanceIndex;
    private int invocationIndex;

    public String toString() {
        StringBuilder builderPattern = new StringBuilder("[%s]: %s.%s(%s)");
        ArrayList<Object> buildParameters = new ArrayList<Object>();
        buildParameters.add(Thread.currentThread().getName());
        buildParameters.add(this.className);
        buildParameters.add(this.methodName);
        buildParameters.add(String.join((CharSequence)", ", this.parameterClassNames));
        if (this.dataProviderIndex != -1) {
            builderPattern.append("[%d]");
            buildParameters.add(this.dataProviderIndex);
        }
        if (this.instanceIndex != -1) {
            builderPattern.append(" ").append("(%d)");
            buildParameters.add(this.instanceIndex);
        }
        if (this.invocationIndex > 1) {
            builderPattern.append(" ").append("InvCount(%d)");
            buildParameters.add(this.invocationIndex);
        }
        return String.format(builderPattern.toString(), buildParameters.toArray());
    }

    public String asJsonString() {
        return GSON.toJson((Object)this);
    }

    public static TestInvocationContext fromJsonString(String jsonContext) {
        return (TestInvocationContext)GSON.fromJson(jsonContext, TestInvocationContext.class);
    }

    public static TestInvocationContextBuilder builder() {
        return new TestInvocationContextBuilder();
    }

    public String getThread() {
        return this.thread;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public List<String> getParameterClassNames() {
        return this.parameterClassNames;
    }

    public int getDataProviderIndex() {
        return this.dataProviderIndex;
    }

    public int getInstanceIndex() {
        return this.instanceIndex;
    }

    public int getInvocationIndex() {
        return this.invocationIndex;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public void setParameterClassNames(List<String> parameterClassNames) {
        this.parameterClassNames = parameterClassNames;
    }

    public void setDataProviderIndex(int dataProviderIndex) {
        this.dataProviderIndex = dataProviderIndex;
    }

    public void setInstanceIndex(int instanceIndex) {
        this.instanceIndex = instanceIndex;
    }

    public void setInvocationIndex(int invocationIndex) {
        this.invocationIndex = invocationIndex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestInvocationContext)) {
            return false;
        }
        TestInvocationContext other = (TestInvocationContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDataProviderIndex() != other.getDataProviderIndex()) {
            return false;
        }
        if (this.getInstanceIndex() != other.getInstanceIndex()) {
            return false;
        }
        if (this.getInvocationIndex() != other.getInvocationIndex()) {
            return false;
        }
        String this$thread = this.getThread();
        String other$thread = other.getThread();
        if (this$thread == null ? other$thread != null : !this$thread.equals(other$thread)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        String this$methodName = this.getMethodName();
        String other$methodName = other.getMethodName();
        if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        List<String> this$parameters = this.getParameters();
        List<String> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        List<String> this$parameterClassNames = this.getParameterClassNames();
        List<String> other$parameterClassNames = other.getParameterClassNames();
        return !(this$parameterClassNames == null ? other$parameterClassNames != null : !((Object)this$parameterClassNames).equals(other$parameterClassNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestInvocationContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDataProviderIndex();
        result = result * 59 + this.getInstanceIndex();
        result = result * 59 + this.getInvocationIndex();
        String $thread = this.getThread();
        result = result * 59 + ($thread == null ? 43 : $thread.hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        String $methodName = this.getMethodName();
        result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        List<String> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        List<String> $parameterClassNames = this.getParameterClassNames();
        result = result * 59 + ($parameterClassNames == null ? 43 : ((Object)$parameterClassNames).hashCode());
        return result;
    }

    public TestInvocationContext() {
    }

    public TestInvocationContext(String className, String methodName, String displayName, List<String> parameters, List<String> parameterClassNames, int dataProviderIndex, int instanceIndex, int invocationIndex) {
        this.className = className;
        this.methodName = methodName;
        this.displayName = displayName;
        this.parameters = parameters;
        this.parameterClassNames = parameterClassNames;
        this.dataProviderIndex = dataProviderIndex;
        this.instanceIndex = instanceIndex;
        this.invocationIndex = invocationIndex;
    }

    public static class TestInvocationContextBuilder {
        private String className;
        private String methodName;
        private String displayName;
        private List<String> parameters;
        private List<String> parameterClassNames;
        private int dataProviderIndex;
        private int instanceIndex;
        private int invocationIndex;

        TestInvocationContextBuilder() {
        }

        public TestInvocationContextBuilder className(String className) {
            this.className = className;
            return this;
        }

        public TestInvocationContextBuilder methodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public TestInvocationContextBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public TestInvocationContextBuilder parameters(List<String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public TestInvocationContextBuilder parameterClassNames(List<String> parameterClassNames) {
            this.parameterClassNames = parameterClassNames;
            return this;
        }

        public TestInvocationContextBuilder dataProviderIndex(int dataProviderIndex) {
            this.dataProviderIndex = dataProviderIndex;
            return this;
        }

        public TestInvocationContextBuilder instanceIndex(int instanceIndex) {
            this.instanceIndex = instanceIndex;
            return this;
        }

        public TestInvocationContextBuilder invocationIndex(int invocationIndex) {
            this.invocationIndex = invocationIndex;
            return this;
        }

        public TestInvocationContext build() {
            return new TestInvocationContext(this.className, this.methodName, this.displayName, this.parameters, this.parameterClassNames, this.dataProviderIndex, this.instanceIndex, this.invocationIndex);
        }

        public String toString() {
            return "TestInvocationContext.TestInvocationContextBuilder(className=" + this.className + ", methodName=" + this.methodName + ", displayName=" + this.displayName + ", parameters=" + this.parameters + ", parameterClassNames=" + this.parameterClassNames + ", dataProviderIndex=" + this.dataProviderIndex + ", instanceIndex=" + this.instanceIndex + ", invocationIndex=" + this.invocationIndex + ")";
        }
    }
}

