/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.testng.listener;

import com.zebrunner.agent.testng.core.FactoryInstanceHolder;
import com.zebrunner.agent.testng.core.TestInvocationContext;
import com.zebrunner.agent.testng.core.TestMethodContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.internal.ConstructorOrMethod;

public class RunContextService {
    private static final Map<TestInvocationContext, Long> INVOCATION_CONTEXT_TO_TEST_IDS = new ConcurrentHashMap<TestInvocationContext, Long>();

    static int countInvocationContexts() {
        return INVOCATION_CONTEXT_TO_TEST_IDS.size();
    }

    static void addInvocationContexts(Map<TestInvocationContext, Long> contexts) {
        contexts.entrySet().stream().filter(contextToTestId -> Objects.nonNull(contextToTestId.getKey())).forEach(RunContextService::addInvocationContext);
    }

    static void addInvocationContext(Map.Entry<TestInvocationContext, Long> contextToTestId) {
        INVOCATION_CONTEXT_TO_TEST_IDS.putIfAbsent(contextToTestId.getKey(), contextToTestId.getValue());
    }

    public static void incrementMethodInvocationIndex(ITestNGMethod method, ITestContext context) {
        RunContextService.getOrInitRunContext(method, context).incrementInvocationIndex();
    }

    public static int getMethodInvocationIndex(ITestNGMethod method, ITestContext context) {
        return RunContextService.getOrInitRunContext(method, context).getCurrentInvocationIndex();
    }

    public static void setDataProviderIndicesForRerun(ITestNGMethod method, ITestContext context, Collection<Integer> indices) {
        RunContextService.getOrInitRunContext(method, context).setDataProviderIndicesForRerun(indices);
    }

    public static List<Integer> getDataProviderIndicesForRerun(ITestNGMethod method, ITestContext context) {
        return RunContextService.getMethodContext(method, context).map(TestMethodContext::getDataProviderIndicesForRerun).orElseGet(Collections::emptyList);
    }

    public static int getDataProviderSize(ITestNGMethod method, ITestContext context) {
        return RunContextService.getOrInitRunContext(method, context).getDataProviderSize();
    }

    public static void setDataProviderData(ITestNGMethod method, ITestContext context, List<Object[]> dataProviderData) {
        RunContextService.getOrInitRunContext(method, context).setDataProviderData(dataProviderData);
    }

    public static void setCurrentDataProviderIteratorIndex(ITestNGMethod method, ITestContext context, int currentDataProviderIteratorIndex) {
        RunContextService.getOrInitRunContext(method, context).setCurrentDataProviderIteratorIndex(currentDataProviderIteratorIndex);
    }

    public static void setCurrentDataProviderData(ITestNGMethod method, ITestContext context, Object[] currentDataProviderData, int index) {
        RunContextService.getOrInitRunContext(method, context).setCurrentDataProviderData(currentDataProviderData, index);
    }

    public static int getCurrentDataProviderIndex(ITestNGMethod method, ITestContext context, Object[] parameters) {
        return RunContextService.getMethodContext(method, context).map(testMethodContext -> testMethodContext.getCurrentDataProviderIndex(parameters)).orElse(-1);
    }

    private static TestMethodContext getOrInitRunContext(ITestNGMethod method, ITestContext context) {
        return RunContextService.getMethodContext(method, context).orElseGet(() -> RunContextService.createEmptyRunContext(method, context));
    }

    private static Optional<TestMethodContext> getMethodContext(ITestNGMethod method, ITestContext context) {
        String uniqueNameByInstanceAndSignature = RunContextService.constructMethodUuid(method);
        return Optional.ofNullable((TestMethodContext)context.getAttribute(uniqueNameByInstanceAndSignature));
    }

    private static TestMethodContext createEmptyRunContext(ITestNGMethod method, ITestContext context) {
        TestMethodContext testMethodContext = new TestMethodContext();
        String uniqueNameByInstanceAndSignature = RunContextService.constructMethodUuid(method);
        context.setAttribute(uniqueNameByInstanceAndSignature, (Object)testMethodContext);
        return testMethodContext;
    }

    private static String constructMethodUuid(ITestNGMethod method) {
        String pattern = "%s.%s(%s)[%d]";
        ConstructorOrMethod constructorOrMethod = method.getConstructorOrMethod();
        String className = method.getTestClass().getName();
        String methodName = constructorOrMethod.getName();
        String argumentTypes = Arrays.stream(constructorOrMethod.getParameterTypes()).map(Class::getName).collect(Collectors.joining(","));
        int instanceIndex = FactoryInstanceHolder.getInstanceIndex(method);
        return String.format(pattern, className, methodName, argumentTypes, instanceIndex);
    }

    public static List<TestInvocationContext> findInvocationsForRerun(ITestNGMethod method) {
        return INVOCATION_CONTEXT_TO_TEST_IDS.keySet().stream().filter(context -> RunContextService.belongsToMethod(context, method)).collect(Collectors.toList());
    }

    public static Optional<Long> getZebrunnerTestIdOnRerun(ITestNGMethod method, Integer dataProviderIndex) {
        return INVOCATION_CONTEXT_TO_TEST_IDS.keySet().stream().filter(context -> RunContextService.belongsToMethod(context, method)).filter(context -> context.getDataProviderIndex() == dataProviderIndex.intValue()).map(INVOCATION_CONTEXT_TO_TEST_IDS::get).findFirst();
    }

    public static boolean isEligibleForRerun(ITestNGMethod method) {
        return INVOCATION_CONTEXT_TO_TEST_IDS.keySet().stream().anyMatch(context -> RunContextService.belongsToMethod(context, method));
    }

    public static boolean belongsToMethod(TestInvocationContext invocationContext, ITestNGMethod method) {
        return invocationContext != null && RunContextService.hasSameMethodSignature(invocationContext, method) && RunContextService.belongsToTheSameFactoryInstance(invocationContext, method);
    }

    private static boolean hasSameMethodSignature(TestInvocationContext invocationContext, ITestNGMethod method) {
        String contextParameters = String.join((CharSequence)", ", invocationContext.getParameterClassNames());
        String methodParameters = String.join((CharSequence)", ", RunContextService.getMethodParameterNames(method));
        return invocationContext.getClassName().equals(method.getTestClass().getName()) && invocationContext.getMethodName().equals(method.getMethodName()) && contextParameters.equals(methodParameters);
    }

    private static List<String> getMethodParameterNames(ITestNGMethod method) {
        return Arrays.stream(method.getConstructorOrMethod().getParameterTypes()).map(Class::getName).collect(Collectors.toList());
    }

    private static boolean belongsToTheSameFactoryInstance(TestInvocationContext invocationContext, ITestNGMethod method) {
        int index = FactoryInstanceHolder.getInstanceIndex(method);
        return invocationContext.getInstanceIndex() == index;
    }

    private RunContextService() {
    }
}

