/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.utils;

import com.zebrunner.carina.utils.PlaceholderResolver;
import com.zebrunner.carina.utils.encryptor.EncryptorUtils;
import com.zebrunner.carina.utils.exception.InvalidConfigurationException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum R {
    API("api.properties"),
    CONFIG("config.properties"),
    TESTDATA("testdata.properties"),
    REPORT("report.properties"),
    DATABASE("database.properties"),
    ZAFIRA("zafira.properties");

    private static final Logger LOGGER;
    private static final String OVERRIDE_SIGN = "_";
    private final String resourceFile;
    private static ThreadLocal<Properties> testProperties;
    private static final ThreadLocal<Map<String, String>> PROPERTY_OVERWRITE_NOTIFICATIONS;
    private static Map<String, Properties> defaultPropertiesHolder;
    private static Map<String, Properties> propertiesHolder;

    public static void reinit() {
        for (R resource : R.values()) {
            try {
                String systemValue;
                URL overrideResource;
                Properties properties = new Properties();
                if (R.isResourceExists(resource.resourceFile)) {
                    Properties collectedProperties = R.collect(resource.resourceFile);
                    properties.putAll((Map<?, ?>)collectedProperties);
                    defaultPropertiesHolder.put(resource.resourceFile, collectedProperties);
                }
                StringBuilder resourceNameBuilder = new StringBuilder(OVERRIDE_SIGN + resource.resourceFile);
                while ((overrideResource = ClassLoader.getSystemResource(resourceNameBuilder.toString())) != null) {
                    Iterator<Object> resourceStream = overrideResource.openStream();
                    try {
                        properties.load((InputStream)((Object)resourceStream));
                        resourceNameBuilder.insert(0, OVERRIDE_SIGN);
                    }
                    finally {
                        if (resourceStream == null) continue;
                        ((InputStream)((Object)resourceStream)).close();
                    }
                }
                for (Object e : properties.keySet()) {
                    systemValue = System.getenv((String)e);
                    if (StringUtils.isEmpty((CharSequence)systemValue)) continue;
                    properties.put(e, systemValue);
                }
                for (Object object : properties.keySet()) {
                    systemValue = System.getProperty((String)object);
                    if (StringUtils.isEmpty((CharSequence)systemValue)) continue;
                    properties.put(object, systemValue);
                }
                if (resource.resourceFile.contains(R.CONFIG.resourceFile)) {
                    String value;
                    String key;
                    String prefix = "capabilities.";
                    HashMap<Object, Object> hashMap = new HashMap<Object, Object>(System.getProperties());
                    for (Map.Entry entry : hashMap.entrySet()) {
                        key = (String)entry.getKey();
                        if (!key.toLowerCase().startsWith("capabilities.") || StringUtils.isEmpty((CharSequence)(value = (String)entry.getValue())) || value.equalsIgnoreCase("NULL")) continue;
                        properties.put(key, value);
                    }
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        key = (String)entry.getKey();
                        value = (String)entry.getValue();
                        if (!key.toLowerCase().startsWith("capabilities.") || !StringUtils.isBlank((CharSequence)value) && !value.equalsIgnoreCase("NULL")) continue;
                        properties.remove(key, value);
                    }
                }
                propertiesHolder.put(resource.resourceFile, properties);
            }
            catch (Exception e) {
                throw new InvalidConfigurationException("Invalid config in '" + resource + "': " + e.getMessage());
            }
        }
    }

    private static boolean isResourceExists(String resourceName) {
        return ClassLoader.getSystemResource(resourceName) != null;
    }

    private static Properties collect(String resourceName) throws IOException {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Properties assembledProperties = new Properties();
        Enumeration<URL> resourceURLs = classLoader.getResources(resourceName);
        while (resourceURLs.hasMoreElements()) {
            Properties tempProperties = new Properties();
            URL url = resourceURLs.nextElement();
            InputStream stream = url.openStream();
            try {
                tempProperties.load(stream);
                assembledProperties.putAll((Map<?, ?>)tempProperties);
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        return assembledProperties;
    }

    private R(String resourceKey) {
        this.resourceFile = resourceKey;
    }

    public boolean isOverwritten(String key) {
        String currentValue = this.get(key);
        String defaultValue = defaultPropertiesHolder.get(this.resourceFile).getProperty(key);
        if (defaultValue == null) {
            defaultValue = "";
        }
        return !currentValue.equals(defaultValue);
    }

    public void put(String key, String value) {
        this.put(key, value, false);
    }

    public void put(String key, String value, boolean currentTestOnly) {
        if (currentTestOnly) {
            LOGGER.warn("Override property for current test '{}={}'!", (Object)key, (Object)value);
            this.getTestProperties().put(key, value);
        } else {
            propertiesHolder.get(this.resourceFile).put(key, value);
        }
    }

    public boolean containsKey(String key) {
        return propertiesHolder.get(this.resourceFile).containsKey(key) || this.getTestProperties().containsKey(key);
    }

    public String get(String key) {
        String value = this.getTestProperties().getProperty(key);
        if (value != null) {
            if (PROPERTY_OVERWRITE_NOTIFICATIONS.get() == null) {
                PROPERTY_OVERWRITE_NOTIFICATIONS.set(new HashMap());
            }
            if (!PROPERTY_OVERWRITE_NOTIFICATIONS.get().containsKey(key) || !value.equals(PROPERTY_OVERWRITE_NOTIFICATIONS.get().get(key))) {
                LOGGER.warn("Overridden '{}={}' property will be used for current test!", (Object)key, (Object)value);
                PROPERTY_OVERWRITE_NOTIFICATIONS.get().put(key, value);
            }
            return value;
        }
        value = R.CONFIG.resourceFile.equals(this.resourceFile) ? PlaceholderResolver.resolve(propertiesHolder.get(this.resourceFile), key) : propertiesHolder.get(this.resourceFile).getProperty(key);
        return value != null ? value : "";
    }

    public String getDecrypted(String key) {
        return EncryptorUtils.decrypt(this.get(key));
    }

    public int getInt(String key) {
        return Integer.parseInt(this.get(key));
    }

    public long getLong(String key) {
        return Long.parseLong(this.get(key));
    }

    public double getDouble(String key) {
        return Double.parseDouble(this.get(key));
    }

    public boolean getBoolean(String key) {
        return Boolean.valueOf(this.get(key));
    }

    public static String getResourcePath(String resource) {
        String path = StringUtils.removeStart((String)ClassLoader.getSystemResource(resource).getPath(), (String)"/");
        path = StringUtils.replaceChars((String)path, (String)"/", (String)"\\");
        path = StringUtils.replaceChars((String)path, (String)"!", (String)"");
        return path;
    }

    public Properties getProperties() {
        Properties globalProp = new Properties();
        globalProp.putAll((Map<?, ?>)propertiesHolder.get(this.resourceFile));
        if (!this.getTestProperties().isEmpty()) {
            Properties testProp = testProperties.get();
            LOGGER.debug("CurrentTestOnly properties has [{}] entries.", (Object)testProp.size());
            LOGGER.debug("{}", (Object)testProp);
            HashMap<Object, Object> testCapabilitiesMap = new HashMap<Object, Object>(testProp);
            testCapabilitiesMap.keySet().stream().forEach(i -> {
                if (globalProp.containsKey(i)) {
                    LOGGER.debug(String.format("Global properties already contains key --- %s --- with value --- %s ---. Global property will be overridden by  --- %s --- from test properties.", i, globalProp.get(i), testProp.get(i)));
                } else {
                    LOGGER.debug(String.format("Global properties isn't contains key --- %s ---.  Global key --- %s --- will be set to --- %s ---  from test properties.", i, i, testProp.get(i)));
                }
                globalProp.setProperty((String)i, (String)testProp.get(i));
            });
        }
        return globalProp;
    }

    public void clearTestProperties() {
        testProperties.remove();
        PROPERTY_OVERWRITE_NOTIFICATIONS.remove();
    }

    public Properties getTestProperties() {
        if (testProperties.get() == null) {
            Properties properties = new Properties();
            testProperties.set(properties);
        }
        return testProperties.get();
    }

    static {
        LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        testProperties = new ThreadLocal();
        PROPERTY_OVERWRITE_NOTIFICATIONS = new ThreadLocal();
        defaultPropertiesHolder = new HashMap<String, Properties>();
        propertiesHolder = new HashMap<String, Properties>();
        R.reinit();
    }
}

