/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.utils.report;

import com.zebrunner.carina.utils.ZipManager;
import com.zebrunner.carina.utils.config.Configuration;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String GALLERY_ZIP = "gallery-lib.zip";
    private static final ThreadLocal<LazyInitializer<Path>> TEST_DIRECTORY = new InheritableThreadLocal<LazyInitializer<Path>>();
    private static final LazyInitializer<Path> PROJECT_REPORT_DIRECTORY_INITIALIZER = new LazyInitializer<Path>(){

        protected Path initialize() throws ConcurrentException {
            try {
                Path projectReportDirectory = Path.of(URLDecoder.decode(System.getProperty("user.dir"), StandardCharsets.UTF_8), new String[0]).resolve(Configuration.getRequired(Configuration.Parameter.PROJECT_REPORT_DIRECTORY)).normalize();
                if (!Files.isDirectory(projectReportDirectory, new LinkOption[0])) {
                    Files.createDirectories(projectReportDirectory, new FileAttribute[0]);
                }
                return projectReportDirectory;
            }
            catch (IOException e) {
                return (Path)ExceptionUtils.rethrow((Throwable)e);
            }
        }
    };
    private static final LazyInitializer<Path> BASE_DIRECTORY_INITIALIZER = new LazyInitializer<Path>(){

        protected Path initialize() throws ConcurrentException {
            try {
                Path baseDirectory = Files.createDirectories(ReportContext.getProjectReportFolder().resolve(String.valueOf(System.currentTimeMillis())), new FileAttribute[0]);
                ReportContext.copyGalleryLib();
                return baseDirectory;
            }
            catch (IOException e) {
                return (Path)ExceptionUtils.rethrow((Throwable)e);
            }
        }
    };
    private static final LazyInitializer<Path> TEMP_DIRECTORY_INITIALIZER = new LazyInitializer<Path>(){

        protected Path initialize() throws ConcurrentException {
            try {
                Path path = ((Path)BASE_DIRECTORY_INITIALIZER.get()).resolve("temp");
                return Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                return (Path)ExceptionUtils.rethrow((Throwable)e);
            }
        }
    };

    private ReportContext() {
    }

    public static Path getBaseDirectory() {
        try {
            return (Path)BASE_DIRECTORY_INITIALIZER.get();
        }
        catch (ConcurrentException e) {
            return (Path)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public static Path getTempDirectory() {
        try {
            return (Path)TEMP_DIRECTORY_INITIALIZER.get();
        }
        catch (ConcurrentException e) {
            return (Path)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public static Path getTestDirectory() {
        if (TEST_DIRECTORY.get() == null) {
            return ReportContext.getBaseDirectory();
        }
        try {
            return (Path)TEST_DIRECTORY.get().get();
        }
        catch (ConcurrentException e) {
            return (Path)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public static Path initTestDirectory() {
        if (TEST_DIRECTORY.get() == null) {
            TEST_DIRECTORY.set(new LazyInitializer<Path>(){

                protected Path initialize() throws ConcurrentException {
                    try {
                        return Files.createDirectories(ReportContext.getBaseDirectory().resolve(UUID.randomUUID().toString()), new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        return (Path)ExceptionUtils.rethrow((Throwable)e);
                    }
                }
            });
        }
        try {
            return (Path)TEST_DIRECTORY.get().get();
        }
        catch (ConcurrentException e) {
            return (Path)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public static Path renameTestDirectory(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Name must not be null, empty or contains whitespaces only.");
        }
        if (TEST_DIRECTORY.get() == null) {
            throw new IllegalStateException("Cannot rename test directory. Method called before test directory initialized.");
        }
        TEST_DIRECTORY.set((LazyInitializer<Path>)new RenameTestFolderInitializer<Path>(ReportContext.getTestDirectory(), RegExUtils.replaceAll((String)name, (String)"[^a-zA-Z0-9.-]", (String)"_")){

            protected Path initialize() throws ConcurrentException {
                try {
                    ReportContext.stopThreadLogAppender();
                    return Files.move(this.getPreviousTestDirectoryPath(), ReportContext.getBaseDirectory().resolve(this.getNewDirectoryName()), new CopyOption[0]);
                }
                catch (IOException e) {
                    return (Path)ExceptionUtils.rethrow((Throwable)e);
                }
            }
        });
        try {
            return (Path)TEST_DIRECTORY.get().get();
        }
        catch (ConcurrentException e) {
            return (Path)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public static void emptyTestDirData() {
        TEST_DIRECTORY.remove();
        ReportContext.stopThreadLogAppender();
    }

    private static Path getProjectReportFolder() {
        try {
            return (Path)PROJECT_REPORT_DIRECTORY_INITIALIZER.get();
        }
        catch (ConcurrentException e) {
            return (Path)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    private static void stopThreadLogAppender() {
        try {
            Class logManagerClass = ClassUtils.getClass((String)"org.apache.logging.log4j.LogManager");
            Object loggerContext = MethodUtils.invokeStaticMethod((Class)logManagerClass, (String)"getContext", (Object[])new Object[]{true});
            Object configuration = MethodUtils.invokeMethod((Object)loggerContext, (String)"getConfiguration");
            Object appender = MethodUtils.invokeMethod((Object)configuration, (String)"getAppender", (Object[])new Object[]{"ThreadLogAppender"});
            if (appender != null) {
                MethodUtils.invokeMethod((Object)appender, (String)"stop");
            }
        }
        catch (Exception e) {
            LOGGER.debug("Exception while closing thread log appender.", (Throwable)e);
        }
    }

    private static void copyGalleryLib() {
        Path galleryLib = ReportContext.getProjectReportFolder().resolve("gallery-lib");
        if (!Files.exists(galleryLib, new LinkOption[0])) {
            try {
                InputStream is = ClassLoader.getSystemClassLoader().getResourceAsStream(GALLERY_ZIP);
                if (is == null) {
                    System.out.println("Unable to find in classpath: gallery-lib.zip");
                    return;
                }
                ZipManager.copyInputStream(is, new BufferedOutputStream(new FileOutputStream(ReportContext.getProjectReportFolder().resolve(GALLERY_ZIP).toFile())));
                ZipManager.unzip(ReportContext.getProjectReportFolder().resolve(GALLERY_ZIP).toFile().toString(), ReportContext.getProjectReportFolder().toString());
                Files.delete(ReportContext.getProjectReportFolder().resolve(GALLERY_ZIP));
            }
            catch (Exception e) {
                System.out.println("Unable to copyGalleryLib! Message: " + e.getMessage());
            }
        }
    }

    @Deprecated(forRemoval=true, since="1.2.6")
    public static File getBaseDir() {
        try {
            return ((Path)BASE_DIRECTORY_INITIALIZER.get()).toFile();
        }
        catch (ConcurrentException e) {
            return (File)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    @Deprecated(forRemoval=true, since="1.2.6")
    public static synchronized File getTempDir() {
        return ReportContext.getTempDirectory().toFile();
    }

    @Deprecated(forRemoval=true, since="1.2.6")
    public static File getTestDir() {
        return ReportContext.getTestDirectory().toFile();
    }

    @Deprecated(forRemoval=true, since="1.2.6")
    public static synchronized File setCustomTestDirName(String dirName) {
        return ReportContext.renameTestDirectory(dirName).toFile();
    }

    @Deprecated(forRemoval=true, since="1.2.6")
    public static synchronized File createTestDir() {
        return ReportContext.initTestDirectory().toFile();
    }

    @Deprecated(forRemoval=true, since="1.2.6")
    public static class CustomAuthenticator
    extends Authenticator {
        String username;
        String password;

        public CustomAuthenticator(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password.toCharArray());
        }
    }

    private static abstract class RenameTestFolderInitializer<T>
    extends LazyInitializer<T> {
        private final Path previousTestDirectoryPath;
        private final String newDirectoryName;

        public RenameTestFolderInitializer(Path previousTestDirectoryPath, String newDirectoryName) {
            this.previousTestDirectoryPath = previousTestDirectoryPath;
            this.newDirectoryName = newDirectoryName;
        }

        public Path getPreviousTestDirectoryPath() {
            return this.previousTestDirectoryPath;
        }

        public String getNewDirectoryName() {
            return this.newDirectoryName;
        }
    }
}

