/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.event;

import java.util.stream.Stream;

public enum EventType {
    UNKNOWN(0),
    START_V3(1),
    QUERY(2),
    STOP(3),
    ROTATE(4),
    INTVAR(5),
    LOAD(6),
    SLAVE(7),
    CREATE_FILE(8),
    APPEND_BLOCK(9),
    EXEC_LOAD(10),
    DELETE_FILE(11),
    NEW_LOAD(12),
    RAND(13),
    USER_VAR(14),
    FORMAT_DESCRIPTION(15),
    XID(16),
    BEGIN_LOAD_QUERY(17),
    EXECUTE_LOAD_QUERY(18),
    TABLE_MAP(19),
    PRE_GA_WRITE_ROWS(20),
    PRE_GA_UPDATE_ROWS(21),
    PRE_GA_DELETE_ROWS(22),
    WRITE_ROWS(23),
    UPDATE_ROWS(24),
    DELETE_ROWS(25),
    INCIDENT(26),
    HEARTBEAT(27),
    IGNORABLE(28),
    ROWS_QUERY(29),
    EXT_WRITE_ROWS(30),
    EXT_UPDATE_ROWS(31),
    EXT_DELETE_ROWS(32),
    GTID(33),
    ANONYMOUS_GTID(34),
    PREVIOUS_GTIDS(35),
    TRANSACTION_CONTEXT(36),
    VIEW_CHANGE(37),
    XA_PREPARE(38),
    PARTIAL_UPDATE_ROWS_EVENT(39),
    TRANSACTION_PAYLOAD(40),
    ANNOTATE_ROWS(160),
    BINLOG_CHECKPOINT(161),
    MARIADB_GTID(162),
    MARIADB_GTID_LIST(163);

    private static final EventType[] TYPE_BY_EVENT_NUMBER;
    private final int eventNumber;

    private EventType(int eventNumber) {
        this.eventNumber = eventNumber;
    }

    private static EventType[] buildEventTypeIndex() {
        EventType[] types = EventType.values();
        int maxEventNumber = Stream.of(types).mapToInt(t -> t.eventNumber).max().orElse(-1);
        EventType[] index = new EventType[maxEventNumber + 1];
        EventType[] eventTypeArray = types;
        int n = eventTypeArray.length;
        for (int i = 0; i < n; ++i) {
            EventType type;
            index[type.eventNumber] = type = eventTypeArray[i];
        }
        return index;
    }

    public static boolean isRowMutation(EventType eventType) {
        return EventType.isWrite(eventType) || EventType.isUpdate(eventType) || EventType.isDelete(eventType);
    }

    public static boolean isWrite(EventType eventType) {
        return eventType == PRE_GA_WRITE_ROWS || eventType == WRITE_ROWS || eventType == EXT_WRITE_ROWS;
    }

    public static boolean isUpdate(EventType eventType) {
        return eventType == PRE_GA_UPDATE_ROWS || eventType == UPDATE_ROWS || eventType == EXT_UPDATE_ROWS;
    }

    public static boolean isDelete(EventType eventType) {
        return eventType == PRE_GA_DELETE_ROWS || eventType == DELETE_ROWS || eventType == EXT_DELETE_ROWS;
    }

    public static EventType byEventNumber(int num) {
        return num >= 0 && num < TYPE_BY_EVENT_NUMBER.length ? TYPE_BY_EVENT_NUMBER[num] : null;
    }

    static {
        TYPE_BY_EVENT_NUMBER = EventType.buildEventTypeIndex();
    }
}

