/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.slider.util;

import de.agilecoders.wicket.extensions.slider.ISliderValue;
import de.agilecoders.wicket.extensions.slider.util.INumericValue;

public class LongValue
implements ISliderValue,
INumericValue<Long> {
    private Long value;

    public LongValue() {
    }

    public LongValue(long value) {
        this.value = value;
    }

    @Override
    public ISliderValue fromString(String value) {
        return new LongValue(Long.parseLong(value));
    }

    @Override
    public String toString() {
        return Double.toString(this.value.longValue());
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    @Override
    public void setValue(Long value) {
        this.value = value;
    }

    @Override
    public Class<? extends Number> getNumberType() {
        return Long.class;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongValue)) {
            return false;
        }
        LongValue longValue = (LongValue)o;
        return this.value.equals(longValue.value);
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }
}

