/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.tempusdominus;

import de.agilecoders.wicket.core.markup.html.bootstrap.image.Icon;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.tempusdominus.TempusDominusBehavior;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.tempusdominus.TempusDominusConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesomeSettings;
import java.io.Serializable;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.model.IModel;

public abstract class AbstractTempusDominusWithIcon<T>
extends FormComponentPanel<T> {
    private static final long serialVersionUID = 1L;
    private TempusDominusConfig config;
    private FormComponent<T> dateInput;

    public AbstractTempusDominusWithIcon(String markupId, TempusDominusConfig config) {
        this(markupId, null, config);
    }

    public AbstractTempusDominusWithIcon(String markupId, IModel<T> model, TempusDominusConfig config) {
        super(markupId, model);
        this.config = config;
    }

    private FormComponent<T> getDateInput() {
        if (this.dateInput == null) {
            this.dateInput = this.newInput("date", this.config.getJavaFormat());
            this.dateInput.setModel(this.getModel());
        }
        return this.dateInput;
    }

    public void convertInput() {
        this.setConvertedInput(this.getDateInput().getConvertedInput());
    }

    protected void onInitialize() {
        super.onInitialize();
        this.setOutputMarkupId(true);
        FormComponent<T> input = this.getDateInput();
        this.setType(input.getType());
        String mainId = "#" + this.getMarkupId();
        input.add(new Behavior[]{AttributeAppender.append((String)"data-td-target", (Serializable)((Object)mainId))});
        Component iconContainer = this.newIconContainer("iconContainer").add(new Component[]{this.newIcon("icon")}).add(new Behavior[]{AttributeAppender.append((String)"data-td-target", (Serializable)((Object)mainId)), AttributeAppender.append((String)"data-td-toggle", (Serializable)((Object)"datetimepicker"))});
        this.add(new Behavior[]{AttributeAppender.append((String)"class", (Serializable)((Object)"input-group date")), AttributeAppender.append((String)"data-td-target-input", (Serializable)((Object)"nearest")), AttributeAppender.append((String)"data-td-target-toggle", (Serializable)((Object)"nearest"))});
        this.add(new Component[]{input, iconContainer});
        this.add(new Behavior[]{new TempusDominusBehavior(this.config)});
    }

    public AbstractTempusDominusWithIcon<T> with(TempusDominusConfig config) {
        this.config = config;
        return this;
    }

    public TempusDominusConfig getConfig() {
        return this.config;
    }

    protected abstract FormComponent<T> newInput(String var1, String var2);

    protected MarkupContainer newIconContainer(String wicketId) {
        return new WebMarkupContainer(wicketId);
    }

    protected Component newIcon(String wicketId) {
        return new Icon(wicketId, this.newIconType());
    }

    protected IconType newIconType() {
        return FontAwesomeSettings.get(Application.get()).getIconType(FontAwesomeSettings.IconKey.CALENDAR);
    }

    public FormComponent<T> setLabel(IModel<String> labelModel) {
        this.getDateInput().setLabel(labelModel);
        return super.setLabel(labelModel);
    }
}

