/*
 * Decompiled with CFR 0.152.
 */
package de.bitgrip.ficum.node;

import de.bitgrip.ficum.node.ConstraintNode;
import de.bitgrip.ficum.node.Node;
import de.bitgrip.ficum.node.OperationNode;
import de.bitgrip.ficum.node.Visitor;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class AbstractVisitor<T>
implements Visitor<T> {
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).appendOffsetId().toFormatter(Locale.ROOT);
    private boolean alwaysWildcard = false;
    private Map<String, String> selectorToFieldMapping = new HashMap<String, String>();

    public static boolean containsWildcard(String value) {
        return value.contains("*") || value.contains("?");
    }

    public void addSelectorToFieldMapping(String selector, String field) {
        this.selectorToFieldMapping.put(selector, field);
    }

    public String getMappedField(String selector) {
        if (this.selectorToFieldMapping.containsKey(selector)) {
            return this.selectorToFieldMapping.get(selector);
        }
        return selector;
    }

    public boolean isAlwaysWildcard() {
        return this.alwaysWildcard;
    }

    public void setAlwaysWildcard(boolean alwaysWildcardMatch) {
        this.alwaysWildcard = alwaysWildcardMatch;
    }

    public void setSelectorToFieldMapping(Map<String, String> selectorToFieldMapping) {
        this.selectorToFieldMapping = selectorToFieldMapping;
    }

    @Override
    public void visit(Node node) {
        if (node instanceof ConstraintNode) {
            this.visit((ConstraintNode)node);
            return;
        }
        if (node instanceof OperationNode) {
            this.visit((OperationNode)node);
            return;
        }
    }

    protected List<Comparable> sanitizeToComparable(List<?> arguments) {
        return arguments.stream().filter(Comparable.class::isInstance).map(Comparable.class::cast).collect(Collectors.toList());
    }
}

