/*
 * Decompiled with CFR 0.152.
 */
package de.bitgrip.ficum.node;

import de.bitgrip.ficum.node.AbstractVisitor;
import de.bitgrip.ficum.node.ConstraintNode;
import de.bitgrip.ficum.node.Node;
import de.bitgrip.ficum.node.OperationNode;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.UUID;

public class QueryPrinterVisitor
extends AbstractVisitor<String> {
    private StringBuffer output;
    private boolean preceded = false;

    private void printArgument(StringBuffer buffer, Object argument) {
        if (argument == null) {
            buffer.append("null");
        } else if (argument instanceof Boolean) {
            buffer.append(argument);
        } else if (argument instanceof Byte) {
            buffer.append(argument);
        } else if (argument instanceof Short) {
            buffer.append(argument);
        } else if (argument instanceof Integer) {
            buffer.append(argument);
        } else if (argument instanceof Float) {
            buffer.append(argument).append('f');
        } else if (argument instanceof Long) {
            buffer.append(argument).append('l');
        } else if (argument instanceof Double) {
            buffer.append(argument);
        } else if (argument instanceof UUID) {
            buffer.append(argument);
        } else if (argument instanceof Date) {
            ZonedDateTime value = ((Date)argument).toInstant().atZone(ZoneOffset.systemDefault());
            buffer.append(ISO_OFFSET_DATE_TIME.format(value));
        } else if (argument instanceof Calendar) {
            OffsetDateTime value = OffsetDateTime.ofInstant(Instant.ofEpochMilli(((Calendar)argument).getTimeInMillis()), ((Calendar)argument).getTimeZone().toZoneId());
            buffer.append(ISO_OFFSET_DATE_TIME.format(value));
        } else if (argument instanceof LocalDate) {
            buffer.append(DateTimeFormatter.ISO_LOCAL_DATE.format((LocalDate)argument));
        } else if (argument instanceof LocalDateTime) {
            buffer.append(ISO_OFFSET_DATE_TIME.format(((LocalDateTime)argument).atZone(ZoneOffset.systemDefault())));
        } else if (argument instanceof OffsetDateTime) {
            buffer.append(ISO_OFFSET_DATE_TIME.format((OffsetDateTime)argument));
        } else if (argument instanceof ZonedDateTime) {
            buffer.append(ISO_OFFSET_DATE_TIME.format((ZonedDateTime)argument));
        } else if (argument instanceof Enum) {
            buffer.append('\'').append(((Enum)argument).name()).append('\'');
        } else if (argument instanceof Iterable) {
            Iterator it = ((Iterable)argument).iterator();
            buffer.append('[');
            if (it.hasNext()) {
                this.printArgument(buffer, it.next());
                while (it.hasNext()) {
                    buffer.append(',');
                    this.printArgument(buffer, it.next());
                }
            }
            buffer.append(']');
        } else {
            buffer.append('\'').append(argument.toString()).append('\'');
        }
    }

    @Override
    public String start(Node node) {
        this.output = new StringBuffer();
        node.accept(this);
        return this.output.toString();
    }

    @Override
    public void visit(ConstraintNode<?> node) {
        this.output.append(node.getSelector());
        this.output.append(node.getComparison().getSign());
        this.printArgument(this.output, node.getArgument());
    }

    @Override
    public void visit(OperationNode node) {
        switch (node.getOperator()) {
            case AND: 
            case NOR: {
                this.preceded = node.getOperator().preceded;
                node.getLeft().accept(this);
                this.output.append(node.getOperator().getSign());
                node.getRight().accept(this);
                this.preceded = false;
                break;
            }
            case OR: 
            case NAND: {
                if (this.preceded) {
                    this.output.append('(');
                }
                node.getLeft().accept(this);
                this.output.append(node.getOperator().getSign());
                node.getRight().accept(this);
                if (!this.preceded) break;
                this.output.append(')');
                break;
            }
            default: {
                throw new IllegalArgumentException("OperationNode: " + node + " does not resolve to a operation");
            }
        }
    }
}

