/*
 * Decompiled with CFR 0.152.
 */
package de.bitgrip.ficum.visitor;

import com.hazelcast.query.Predicate;
import com.hazelcast.query.Predicates;
import de.bitgrip.ficum.node.AbstractVisitor;
import de.bitgrip.ficum.node.Comparison;
import de.bitgrip.ficum.node.ConstraintNode;
import de.bitgrip.ficum.node.Node;
import de.bitgrip.ficum.node.OperationNode;
import de.bitgrip.ficum.node.Visitor;
import de.bitgrip.ficum.visitor.Wildcards;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class HazelcastPredicateVisitor
extends AbstractVisitor<Predicate<?, ?>> {
    private List<Predicate<?, ?>> filters;

    private Predicate<?, ?> buildEquals(String fieldName, Comparable<?> argument) {
        Predicate pred;
        if (argument instanceof String) {
            String value = (String)((Object)argument);
            if (HazelcastPredicateVisitor.containsWildcard((String)value) || this.isAlwaysWildcard()) {
                String like = Wildcards.escapeAndConvertToSQLWildcards(value, this.isAlwaysWildcard());
                pred = Predicates.like((String)fieldName, (String)like);
            } else {
                pred = Predicates.equal((String)fieldName, (Comparable)((Object)value));
            }
        } else {
            pred = Predicates.equal((String)fieldName, argument);
        }
        return pred;
    }

    private Predicate<?, ?> buildNotEquals(String fieldName, Comparable<?> argument) {
        Predicate pred;
        if (argument instanceof String) {
            String value = (String)((Object)argument);
            if (HazelcastPredicateVisitor.containsWildcard((String)value) || this.isAlwaysWildcard()) {
                String like = Wildcards.escapeAndConvertToSQLWildcards(value, this.isAlwaysWildcard());
                pred = Predicates.not((Predicate)Predicates.like((String)fieldName, (String)like));
            } else {
                pred = Predicates.notEqual((String)fieldName, (Comparable)((Object)value));
            }
        } else {
            pred = Predicates.notEqual((String)fieldName, argument);
        }
        return pred;
    }

    private Predicate<?, ?> doBuildPredicate(Comparison comparison, String fieldName, Comparable<?> argument) {
        switch (comparison) {
            case GREATER_THAN: {
                return Predicates.greaterThan((String)fieldName, argument);
            }
            case EQUALS: {
                return this.buildEquals(fieldName, argument);
            }
            case NOT_EQUALS: {
                return this.buildNotEquals(fieldName, argument);
            }
            case LESS_THAN: {
                return Predicates.lessThan((String)fieldName, argument);
            }
            case LESS_EQUALS: {
                return Predicates.lessEqual((String)fieldName, argument);
            }
            case GREATER_EQUALS: {
                return Predicates.greaterEqual((String)fieldName, argument);
            }
            case IN: 
            case NIN: {
                return this.doBuildPredicate(comparison, fieldName, Collections.singletonList(argument));
            }
        }
        return null;
    }

    private Predicate<?, ?> doBuildPredicate(Comparison comparison, String fieldName, List<Comparable> arguments) {
        switch (comparison) {
            case IN: {
                return Predicates.in((String)fieldName, (Comparable[])arguments.toArray(new Comparable[arguments.size()]));
            }
            case NIN: {
                return Predicates.not((Predicate)Predicates.in((String)fieldName, (Comparable[])arguments.toArray(new Comparable[arguments.size()])));
            }
        }
        return null;
    }

    public Predicate<?, ?> start(Node node) {
        this.filters = new ArrayList();
        node.accept((Visitor)this);
        if (this.filters.size() != 1) {
            throw new IllegalStateException("single predicate expected, but was: " + this.filters);
        }
        return this.filters.get(0);
    }

    public void visit(ConstraintNode<?> node) {
        Object argument = node.getArgument();
        String fieldName = this.getMappedField(node.getSelector());
        Predicate<?, ?> pred = null;
        if (argument instanceof Comparable) {
            Comparable value = (Comparable)argument;
            if (argument instanceof LocalDate) {
                value = Date.from(((LocalDate)value).atStartOfDay().atZone(ZoneId.of("UTC")).toInstant());
            }
            if (argument instanceof OffsetDateTime) {
                value = Date.from(((OffsetDateTime)value).toInstant());
            }
            pred = this.doBuildPredicate(node.getComparison(), fieldName, value);
        } else if (argument instanceof List) {
            pred = this.doBuildPredicate(node.getComparison(), fieldName, this.sanitizeToComparable((List)argument));
        } else if (argument == null) {
            pred = this.doBuildPredicate(node.getComparison(), fieldName, (Comparable)null);
        } else {
            throw new IllegalArgumentException("Unable to handle argument of type " + argument.getClass().getName());
        }
        if (pred == null) {
            throw new IllegalArgumentException("Constraint: " + node + " does not resolve to a predicate");
        }
        this.filters.add(pred);
    }

    public void visit(OperationNode node) {
        node.getLeft().accept((Visitor)this);
        node.getRight().accept((Visitor)this);
        Predicate pred = null;
        Predicate<?, ?> leftHandSide = this.filters.get(this.filters.size() - 2);
        Predicate<?, ?> rightHandSide = this.filters.get(this.filters.size() - 1);
        switch (node.getOperator()) {
            case AND: {
                pred = Predicates.and((Predicate[])new Predicate[]{leftHandSide, rightHandSide});
                break;
            }
            case OR: {
                pred = Predicates.or((Predicate[])new Predicate[]{leftHandSide, rightHandSide});
                break;
            }
            case NAND: {
                pred = Predicates.or((Predicate[])new Predicate[]{Predicates.not(leftHandSide), Predicates.not(rightHandSide)});
                break;
            }
            case NOR: {
                pred = Predicates.and((Predicate[])new Predicate[]{Predicates.not(leftHandSide), Predicates.not(rightHandSide)});
                break;
            }
            default: {
                throw new IllegalArgumentException("OperationNode: " + node + " does not resolve to a operation");
            }
        }
        this.filters.remove(leftHandSide);
        this.filters.remove(rightHandSide);
        this.filters.add(pred);
    }
}

