/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.aggregation.accumulator;

import de.bwaldvogel.mongo.backend.Missing;
import de.bwaldvogel.mongo.backend.aggregation.accumulator.Accumulator;
import java.util.Comparator;

class ComparingAccumulator
extends Accumulator {
    private final Comparator<Object> comparator;
    private Object result;

    ComparingAccumulator(String field, Object expression, Comparator<Object> comparator) {
        super(field, expression);
        this.comparator = comparator;
    }

    @Override
    public void aggregate(Object value) {
        if (Missing.isNullOrMissing(value)) {
            return;
        }
        if (this.result == null) {
            this.result = value;
        } else if (this.comparator.compare(value, this.result) < 0) {
            this.result = value;
        }
    }

    @Override
    public Object getResult() {
        return this.result;
    }
}

