/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.wire.bson;

import de.bwaldvogel.mongo.bson.BsonJavaScript;
import de.bwaldvogel.mongo.bson.BsonRegularExpression;
import de.bwaldvogel.mongo.bson.BsonTimestamp;
import de.bwaldvogel.mongo.bson.Decimal128;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.bson.MaxKey;
import de.bwaldvogel.mongo.bson.MinKey;
import de.bwaldvogel.mongo.bson.ObjectId;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class BsonEncoder {
    private BsonEncoder() {
    }

    public static void encodeDocument(Map<String, ?> document, ByteBuf out) {
        int indexBefore = out.writerIndex();
        out.writeIntLE(0);
        for (String key : document.keySet()) {
            BsonEncoder.encodeValue(key, document.get(key), out);
        }
        out.writeByte(0);
        int indexAfter = out.writerIndex();
        out.writerIndex(indexBefore);
        out.writeIntLE(indexAfter - indexBefore);
        out.writerIndex(indexAfter);
    }

    private static void encodeCString(String data, ByteBuf buffer) {
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        buffer.writeBytes(bytes);
        buffer.writeByte(0);
    }

    private static void encodeString(String data, ByteBuf buffer) {
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        buffer.writeIntLE(bytes.length + 1);
        buffer.writeBytes(bytes);
        buffer.writeByte(0);
    }

    private static void encodeValue(String key, Object value, ByteBuf buffer) {
        byte type = BsonEncoder.determineType(value);
        buffer.writeByte((int)type);
        BsonEncoder.encodeCString(key, buffer);
        BsonEncoder.encodeValue(type, value, buffer);
    }

    public static void encodeValue(byte type, Object value, ByteBuf buffer) {
        switch (type) {
            case 1: {
                buffer.writeLongLE(Double.doubleToRawLongBits((Double)value));
                break;
            }
            case 2: {
                BsonEncoder.encodeString(value.toString(), buffer);
                break;
            }
            case 3: {
                Map valueAsMap = (Map)value;
                BsonEncoder.encodeDocument(valueAsMap, buffer);
                break;
            }
            case 4: {
                Document document = new Document();
                List<?> array = BsonEncoder.collectionToList(value);
                for (int i = 0; i < array.size(); ++i) {
                    document.put(String.valueOf(i), array.get(i));
                }
                BsonEncoder.encodeDocument(document, buffer);
                break;
            }
            case 5: {
                if (value instanceof byte[]) {
                    byte[] data = (byte[])value;
                    buffer.writeIntLE(data.length);
                    buffer.writeByte(0);
                    buffer.writeBytes(data);
                    break;
                }
                if (value instanceof UUID) {
                    buffer.writeIntLE(16);
                    buffer.writeByte(3);
                    UUID uuid = (UUID)value;
                    buffer.writeLongLE(uuid.getMostSignificantBits());
                    buffer.writeLongLE(uuid.getLeastSignificantBits());
                    break;
                }
                throw new IllegalArgumentException("Unknown data: " + value.getClass());
            }
            case 7: {
                byte[] bytes = ((ObjectId)value).toByteArray();
                if (bytes.length != 12) {
                    throw new IllegalArgumentException("Illegal ObjectId: " + value);
                }
                buffer.writeBytes(bytes);
                break;
            }
            case 8: {
                if (((Boolean)value).booleanValue()) {
                    buffer.writeByte(1);
                    break;
                }
                buffer.writeByte(0);
                break;
            }
            case 9: {
                Instant instant = (Instant)value;
                buffer.writeLongLE(instant.toEpochMilli());
                break;
            }
            case 11: {
                BsonRegularExpression pattern = (BsonRegularExpression)value;
                BsonEncoder.encodeCString(pattern.getPattern(), buffer);
                BsonEncoder.encodeCString(pattern.getOptions(), buffer);
                break;
            }
            case 16: {
                buffer.writeIntLE(((Integer)value).intValue());
                break;
            }
            case 17: {
                BsonTimestamp timestamp = (BsonTimestamp)value;
                buffer.writeLongLE(timestamp.getTimestamp());
                break;
            }
            case 18: {
                buffer.writeLongLE(((Long)value).longValue());
                break;
            }
            case 19: {
                Decimal128 decimal128 = (Decimal128)value;
                buffer.writeLongLE(decimal128.getLow());
                buffer.writeLongLE(decimal128.getHigh());
                break;
            }
            case -1: 
            case 6: 
            case 10: 
            case 127: {
                break;
            }
            case 13: {
                BsonJavaScript javaScript = (BsonJavaScript)value;
                BsonEncoder.encodeString(javaScript.getCode(), buffer);
                break;
            }
            case 15: {
                throw new IllegalArgumentException("unhandled type: " + value.getClass());
            }
            default: {
                throw new IllegalArgumentException("unknown type: " + value.getClass());
            }
        }
    }

    public static byte determineType(Object value) {
        if (value == null) {
            return 10;
        }
        if (value instanceof Map) {
            return 3;
        }
        if (value instanceof ObjectId) {
            return 7;
        }
        if (value instanceof Integer) {
            return 16;
        }
        if (value instanceof Long) {
            return 18;
        }
        if (value instanceof Decimal128) {
            return 19;
        }
        if (value instanceof Double) {
            return 1;
        }
        if (value instanceof String) {
            return 2;
        }
        if (value instanceof Boolean) {
            return 8;
        }
        if (value instanceof byte[]) {
            return 5;
        }
        if (value instanceof Collection || value instanceof String[]) {
            return 4;
        }
        if (value instanceof Instant) {
            return 9;
        }
        if (value instanceof BsonTimestamp) {
            return 17;
        }
        if (value instanceof BsonRegularExpression) {
            return 11;
        }
        if (value instanceof MaxKey) {
            return 127;
        }
        if (value instanceof MinKey) {
            return -1;
        }
        if (value instanceof UUID) {
            return 5;
        }
        if (value instanceof BsonJavaScript) {
            return 13;
        }
        throw new IllegalArgumentException("Unknown type: " + value.getClass());
    }

    private static List<?> collectionToList(Object value) {
        if (value instanceof String[]) {
            return Arrays.asList((String[])value);
        }
        if (value instanceof List) {
            return (List)value;
        }
        return new ArrayList((Collection)value);
    }
}

