/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.wire.message;

import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.wire.ReplyFlag;
import de.bwaldvogel.mongo.wire.message.MessageHeader;
import java.util.Collections;
import java.util.List;

public class MongoReply {
    private final MessageHeader header;
    private final List<? extends Document> documents;
    private long cursorId;
    private int startingFrom;
    private int flags;

    public MongoReply(MessageHeader header, Document document, ReplyFlag ... replyFlags) {
        this(header, Collections.singletonList(document), replyFlags);
    }

    public MongoReply(MessageHeader header, List<? extends Document> documents, ReplyFlag ... replyFlags) {
        this.header = header;
        this.documents = documents;
        for (ReplyFlag replyFlag : replyFlags) {
            this.flags = replyFlag.addTo(this.flags);
        }
    }

    public MessageHeader getHeader() {
        return this.header;
    }

    public List<Document> getDocuments() {
        return Collections.unmodifiableList(this.documents);
    }

    public long getCursorId() {
        return this.cursorId;
    }

    public int getStartingFrom() {
        return this.startingFrom;
    }

    public int getFlags() {
        return this.flags;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("(");
        sb.append("documents: ").append(this.getDocuments());
        sb.append(")");
        return sb.toString();
    }
}

