/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.bson.BsonTimestamp;
import de.bwaldvogel.mongo.bson.Decimal128;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.bson.LegacyUUID;
import de.bwaldvogel.mongo.bson.MaxKey;
import de.bwaldvogel.mongo.bson.MinKey;
import de.bwaldvogel.mongo.bson.ObjectId;
import de.bwaldvogel.mongo.exception.BadValueException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;

enum BsonType {
    DOUBLE(1, "double", Double.class),
    STRING(2, "string", String.class),
    OBJECT(3, "object", Document.class),
    ARRAY(4, "array", Collection.class),
    BIN_DATA(5, "binData", byte[].class, LegacyUUID.class, UUID.class),
    OBJECT_ID(7, "objectId", ObjectId.class),
    BOOL(8, "bool", Boolean.class),
    DATE(9, "date", Instant.class),
    NULL(10, "null", new Class[0]){

        @Override
        public boolean matches(Object value) {
            return value == null;
        }
    }
    ,
    REGEX(11, "regex", Pattern.class),
    INT(16, "int", Integer.class),
    TIMESTAMP(17, "timestamp", BsonTimestamp.class),
    LONG(18, "long", Long.class),
    DECIMAL128(19, "decimal", Decimal128.class),
    MIN_KEY(-1, "minKey", MinKey.class),
    MAX_KEY(127, "maxKey", MaxKey.class);

    private final int number;
    private final String alias;
    private final Set<Class<?>> classes;

    private BsonType(int number, String alias, Class<?> ... classes) {
        this.number = number;
        this.alias = alias;
        this.classes = new LinkedHashSet(Arrays.asList(classes));
    }

    public static BsonType forString(String value) {
        for (BsonType bsonType : BsonType.values()) {
            if (!bsonType.getAlias().equals(value)) continue;
            return bsonType;
        }
        throw new BadValueException("Unknown type name alias: " + value);
    }

    public static BsonType forNumber(Number value) {
        int type = value.intValue();
        if ((double)type != value.doubleValue()) {
            throw new BadValueException("Invalid numerical type code: " + value);
        }
        for (BsonType bsonType : BsonType.values()) {
            if (bsonType.getNumber() != type) continue;
            return bsonType;
        }
        throw new IllegalArgumentException("Unknown type: " + value);
    }

    public boolean matches(Object value) {
        if (value == null) {
            return false;
        }
        return this.classes.stream().anyMatch(clazz -> clazz.isAssignableFrom(value.getClass()));
    }

    public int getNumber() {
        return this.number;
    }

    public String getAlias() {
        return this.alias;
    }
}

