/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.aggregation;

import de.bwaldvogel.mongo.MongoCollection;
import de.bwaldvogel.mongo.MongoDatabase;
import de.bwaldvogel.mongo.backend.Assert;
import de.bwaldvogel.mongo.backend.CollectionUtils;
import de.bwaldvogel.mongo.backend.aggregation.stage.AddFieldsStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.AggregationStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.BucketStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.FacetStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.GraphLookupStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.GroupStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.IndexStatsStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.LimitStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.LookupStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.LookupWithPipelineStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.MatchStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.OrderByStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.OutStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.ProjectStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.RedactStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.ReplaceRootStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.SkipStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.UnsetStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.UnwindStage;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.FailedToParseException;
import de.bwaldvogel.mongo.exception.MongoServerError;
import de.bwaldvogel.mongo.exception.MongoServerNotYetImplementedException;
import de.bwaldvogel.mongo.exception.TypeMismatchException;
import de.bwaldvogel.mongo.oplog.Oplog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Aggregation {
    private static final Logger log = LoggerFactory.getLogger(Aggregation.class);
    private final MongoCollection<?> collection;
    private final List<AggregationStage> stages = new ArrayList<AggregationStage>();
    private Map<String, Object> variables = Collections.emptyMap();

    private Aggregation(MongoCollection<?> collection) {
        this.collection = collection;
    }

    public static List<Document> parse(Object pipelineObject) {
        if (!(pipelineObject instanceof List)) {
            throw new TypeMismatchException("'pipeline' option must be specified as an array");
        }
        ArrayList<Document> pipeline = new ArrayList<Document>();
        for (Object pipelineElement : (List)pipelineObject) {
            if (!(pipelineElement instanceof Document)) {
                throw new TypeMismatchException("Each element of the 'pipeline' array must be an object");
            }
            pipeline.add((Document)pipelineElement);
        }
        return pipeline;
    }

    public static Aggregation fromPipeline(Object pipelineObject, MongoDatabase database, MongoCollection<?> collection, Oplog oplog) {
        List<Document> pipeline = Aggregation.parse(pipelineObject);
        return Aggregation.fromPipeline(pipeline, database, collection, oplog);
    }

    public static Aggregation fromPipeline(List<Document> pipeline, MongoDatabase database, MongoCollection<?> collection, Oplog oplog) {
        Aggregation aggregation = new Aggregation(collection);
        block46: for (Document stage : pipeline) {
            String stageOperation;
            switch (stageOperation = CollectionUtils.getSingleElement(stage.keySet(), () -> {
                throw new MongoServerError(40323, "A pipeline stage specification object must contain exactly one field.");
            })) {
                case "$match": {
                    Document matchQuery = (Document)stage.get(stageOperation);
                    aggregation.addStage(new MatchStage(matchQuery));
                    continue block46;
                }
                case "$skip": {
                    Number numSkip = (Number)stage.get(stageOperation);
                    aggregation.addStage(new SkipStage(numSkip.longValue()));
                    continue block46;
                }
                case "$limit": {
                    Number numLimit = (Number)stage.get(stageOperation);
                    aggregation.addStage(new LimitStage(numLimit.longValue()));
                    continue block46;
                }
                case "$sort": {
                    Document orderBy = (Document)stage.get(stageOperation);
                    aggregation.addStage(new OrderByStage(orderBy));
                    continue block46;
                }
                case "$project": {
                    Document projection = (Document)stage.get(stageOperation);
                    aggregation.addStage(new ProjectStage(projection));
                    continue block46;
                }
                case "$count": {
                    String count = (String)stage.get(stageOperation);
                    aggregation.addStage(new GroupStage(new Document("_id", null).append(count, new Document("$sum", 1))));
                    aggregation.addStage(new ProjectStage(new Document("_id", 0)));
                    continue block46;
                }
                case "$group": {
                    Document groupDetails = (Document)stage.get(stageOperation);
                    aggregation.addStage(new GroupStage(groupDetails));
                    continue block46;
                }
                case "$addFields": {
                    Document addFieldsDetails = (Document)stage.get(stageOperation);
                    aggregation.addStage(new AddFieldsStage(addFieldsDetails));
                    continue block46;
                }
                case "$unwind": {
                    Object unwind = stage.get(stageOperation);
                    aggregation.addStage(new UnwindStage(unwind));
                    continue block46;
                }
                case "$graphLookup": {
                    Document graphLookup = (Document)stage.get(stageOperation);
                    aggregation.addStage(new GraphLookupStage(graphLookup, database));
                    continue block46;
                }
                case "$lookup": {
                    Document lookup = (Document)stage.get(stageOperation);
                    if (lookup.containsKey("pipeline")) {
                        aggregation.addStage(new LookupWithPipelineStage(lookup, database, oplog));
                        continue block46;
                    }
                    aggregation.addStage(new LookupStage(lookup, database));
                    continue block46;
                }
                case "$replaceRoot": {
                    Document replaceRoot = (Document)stage.get(stageOperation);
                    aggregation.addStage(new ReplaceRootStage(replaceRoot));
                    continue block46;
                }
                case "$sortByCount": {
                    Object expression = stage.get(stageOperation);
                    aggregation.addStage(new GroupStage(new Document("_id", expression).append("count", new Document("$sum", 1))));
                    aggregation.addStage(new OrderByStage(new Document("count", -1).append("_id", 1)));
                    continue block46;
                }
                case "$bucket": {
                    Document bucket = (Document)stage.get(stageOperation);
                    aggregation.addStage(new BucketStage(bucket));
                    continue block46;
                }
                case "$facet": {
                    Document facet = (Document)stage.get(stageOperation);
                    aggregation.addStage(new FacetStage(facet, database, collection, oplog));
                    continue block46;
                }
                case "$unset": {
                    Object unset = stage.get(stageOperation);
                    aggregation.addStage(new UnsetStage(unset));
                    continue block46;
                }
                case "$indexStats": {
                    aggregation.addStage(new IndexStatsStage(collection));
                    continue block46;
                }
                case "$out": {
                    Object outCollection = stage.get(stageOperation);
                    aggregation.addStage(new OutStage(database, outCollection));
                    continue block46;
                }
                case "$redact": {
                    Document redactExpression = (Document)stage.get(stageOperation);
                    aggregation.addStage(new RedactStage(redactExpression));
                    continue block46;
                }
                case "$geoNear": {
                    throw new MongoServerNotYetImplementedException(138, stageOperation);
                }
                case "$merge": {
                    throw new MongoServerNotYetImplementedException(152, stageOperation);
                }
            }
            throw new MongoServerError(40324, "Unrecognized pipeline stage name: '" + stageOperation + "'");
        }
        return aggregation;
    }

    private List<Document> runStages() {
        return this.runStages(this.collection.queryAllAsStream());
    }

    public List<Document> runStages(Stream<Document> stream) {
        return this.runStagesAsStream(stream).collect(Collectors.toList());
    }

    public Stream<Document> runStagesAsStream(Stream<Document> stream) {
        if (this.hasVariables()) {
            stream = stream.map(this::addAllVariables);
        }
        for (AggregationStage stage : this.stages) {
            stream = stage.apply(stream);
        }
        if (this.hasVariables()) {
            stream = stream.map(this::removeAllVariables);
        }
        return stream;
    }

    private boolean hasVariables() {
        return !this.variables.isEmpty();
    }

    private Document addAllVariables(Document document) {
        Document clone = document.clone();
        clone.putAll((Map<? extends String, ?>)this.variables);
        return clone;
    }

    private Document removeAllVariables(Document document) {
        return CollectionUtils.removeAll(document, this.variables.keySet());
    }

    private void addStage(AggregationStage stage) {
        this.stages.add(stage);
    }

    public List<Document> computeResult() {
        if (this.collection == null) {
            return Collections.emptyList();
        }
        return this.runStages();
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = Collections.unmodifiableMap(variables);
    }

    private Optional<AggregationStage> findFirstOutStage() {
        return this.stages.stream().filter(stage -> stage instanceof OutStage).findFirst();
    }

    public void validate(Document query) {
        Optional<AggregationStage> firstOutStage = this.findFirstOutStage();
        if (firstOutStage.isPresent()) {
            if (!this.isLastStage(firstOutStage.get())) {
                throw new MongoServerError(40601, "$out can only be the final stage in the pipeline");
            }
        } else {
            Document cursor = (Document)query.get("cursor");
            if (cursor == null) {
                throw new FailedToParseException("The 'cursor' option is required, except for aggregate with the explain argument");
            }
            if (!cursor.isEmpty()) {
                log.warn("Non-empty cursor is not yet implemented. Ignoring.");
            }
        }
    }

    private boolean isLastStage(AggregationStage aggregationStage) {
        Assert.notEmpty(this.stages);
        return this.stages.indexOf(aggregationStage) == this.stages.size() - 1;
    }
}

