/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.aggregation.stage;

import de.bwaldvogel.mongo.MongoCollection;
import de.bwaldvogel.mongo.MongoDatabase;
import de.bwaldvogel.mongo.backend.CollectionOptions;
import de.bwaldvogel.mongo.backend.aggregation.stage.AggregationStage;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.MongoServerError;
import java.util.Collections;
import java.util.stream.Stream;

public class OutStage
implements AggregationStage {
    private final MongoDatabase database;
    private final String collectionName;

    public OutStage(MongoDatabase database, Object collectionName) {
        this.database = database;
        this.collectionName = (String)collectionName;
        if (this.collectionName.contains("$")) {
            throw new MongoServerError(17385, "Can't $out to special collection: " + this.collectionName);
        }
    }

    @Override
    public Stream<Document> apply(Stream<Document> stream) {
        String tempCollectionName = "_tmp" + System.currentTimeMillis() + "_" + this.collectionName;
        MongoCollection<?> tempCollection = this.database.createCollectionOrThrowIfExists(tempCollectionName, CollectionOptions.withDefaults());
        stream.forEach(document -> tempCollection.insertDocuments(Collections.singletonList(document)));
        this.database.moveCollection(this.database, tempCollection, this.collectionName);
        return Stream.empty();
    }
}

