/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.bson;

import de.bwaldvogel.mongo.backend.Missing;
import de.bwaldvogel.mongo.bson.Bson;
import de.bwaldvogel.mongo.bson.Json;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class Document
implements Map<String, Object>,
Bson {
    private static final long serialVersionUID = 1L;
    private final LinkedHashMap<String, Object> documentAsMap = new LinkedHashMap();

    public Document() {
    }

    public Document(String key, Object value) {
        this();
        this.append(key, value);
    }

    public Document(Map<String, ?> map) {
        this();
        this.putAll((Map<? extends String, ?>)map);
    }

    public void cloneInto(Document targetDocument) {
        for (Map.Entry<String, Object> entry : this.entrySet()) {
            targetDocument.put(entry.getKey(), Document.cloneDeeply(entry.getValue()));
        }
    }

    public Document cloneDeeply() {
        return Document.cloneDeeply(this);
    }

    private static <T> T cloneDeeply(T object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Document) {
            Document document = (Document)object;
            Document clone = document.clone();
            for (String key : document.keySet()) {
                clone.put(key, Document.cloneDeeply(clone.get(key)));
            }
            return (T)clone;
        }
        if (object instanceof List) {
            List list = (List)object;
            List result = list.stream().map(Document::cloneDeeply).collect(Collectors.toList());
            return (T)result;
        }
        if (object instanceof Set) {
            Set set = (Set)object;
            Set result = set.stream().map(Document::cloneDeeply).collect(Collectors.toCollection(LinkedHashSet::new));
            return (T)result;
        }
        return object;
    }

    public Document append(String key, Object value) {
        this.put(key, value);
        return this;
    }

    public Document appendAll(Map<String, Object> map) {
        this.putAll((Map<? extends String, ?>)map);
        return this;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.documentAsMap.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.documentAsMap.get(key);
    }

    public Object getOrMissing(Object key) {
        return this.getOrDefault(key, Missing.getInstance());
    }

    @Override
    public void clear() {
        this.documentAsMap.clear();
    }

    @Override
    public int size() {
        return this.documentAsMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.documentAsMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.documentAsMap.containsKey(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.documentAsMap.put(key, value);
    }

    public void putIfNotNull(String key, Object value) {
        if (value != null) {
            this.put(key, value);
        }
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        this.documentAsMap.putAll(m);
    }

    @Override
    public Object remove(Object key) {
        return this.documentAsMap.remove(key);
    }

    public Document clone() {
        return new Document((Map)this.documentAsMap.clone());
    }

    @Override
    public Set<String> keySet() {
        return this.documentAsMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.documentAsMap.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.documentAsMap.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        ArrayList<String> otherKeys;
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Document)) {
            return false;
        }
        ArrayList<String> keys = new ArrayList<String>(this.keySet());
        if (!keys.equals(otherKeys = new ArrayList<String>(((Document)o).keySet()))) {
            return false;
        }
        return this.documentAsMap.equals(o);
    }

    @Override
    public int hashCode() {
        return this.documentAsMap.hashCode();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean compactKey) {
        return this.toString(compactKey, "{", "}");
    }

    public String toString(boolean compactKey, String prefix, String suffix) {
        return this.documentAsMap.entrySet().stream().map(entry -> this.writeKey((String)entry.getKey(), compactKey) + " " + Json.toJsonValue(entry.getValue(), compactKey, prefix, suffix)).collect(Collectors.joining(", ", prefix, suffix));
    }

    private String writeKey(String key, boolean compact) {
        if (compact) {
            return Json.escapeJson(key) + ":";
        }
        return "\"" + Json.escapeJson(key) + "\" :";
    }
}

