/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.backend.AbstractCursor;
import de.bwaldvogel.mongo.backend.Assert;
import de.bwaldvogel.mongo.bson.Document;
import java.util.Collections;
import java.util.List;

public class InMemoryCursor
extends AbstractCursor {
    private List<Document> remainingDocuments;

    public InMemoryCursor(long cursorId, List<Document> remainingDocuments) {
        super(cursorId);
        Assert.notEmpty(remainingDocuments);
        this.remainingDocuments = Collections.unmodifiableList(remainingDocuments);
    }

    @Override
    public boolean isEmpty() {
        return this.remainingDocuments.isEmpty();
    }

    @Override
    public List<Document> takeDocuments(int numberToReturn) {
        Assert.isTrue(numberToReturn > 0, () -> "Illegal number to return: " + numberToReturn);
        int toIndex = Math.min(this.remainingDocuments.size(), numberToReturn);
        List<Document> documents = this.remainingDocuments.subList(0, toIndex);
        this.remainingDocuments = this.remainingDocuments.subList(documents.size(), this.remainingDocuments.size());
        return documents;
    }
}

