/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.wire.message;

import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.wire.message.ClientRequest;
import de.bwaldvogel.mongo.wire.message.MessageHeader;
import io.netty.channel.Channel;

public class MongoQuery
extends ClientRequest {
    private final Document query;
    private final Document returnFieldSelector;
    private final int numberToSkip;
    private final int numberToReturn;

    public MongoQuery(Channel channel, MessageHeader header, String fullCollectionName, int numberToSkip, int numberToReturn, Document query, Document returnFieldSelector) {
        super(channel, header, fullCollectionName);
        this.numberToSkip = numberToSkip;
        this.numberToReturn = numberToReturn;
        this.query = query;
        this.returnFieldSelector = returnFieldSelector;
    }

    public int getNumberToSkip() {
        return this.numberToSkip;
    }

    public int getNumberToReturn() {
        return this.numberToReturn;
    }

    public Document getQuery() {
        return this.query;
    }

    public Document getReturnFieldSelector() {
        return this.returnFieldSelector;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("(");
        sb.append("header: ").append(this.getHeader());
        sb.append(", collection: ").append(this.getFullCollectionName());
        sb.append(", query: ").append(this.query);
        sb.append(", returnFieldSelector: ").append(this.returnFieldSelector);
        sb.append(")");
        return sb.toString();
    }
}

