/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.aggregation.stage;

import de.bwaldvogel.mongo.MongoCollection;
import de.bwaldvogel.mongo.MongoDatabase;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.aggregation.stage.AbstractLookupStage;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.FailedToParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GraphLookupStage
extends AbstractLookupStage {
    private static final String START_WITH = "startWith";
    private static final String CONNECT_FROM_FIELD = "connectFromField";
    private static final String CONNECT_TO_FIELD = "connectToField";
    private static final String MAX_DEPTH = "maxDepth";
    private static final String DEPTH_FIELD = "depthField";
    private static final Set<String> CONFIGURATION_KEYS = new HashSet<String>();
    private final String connectFromField;
    private final String connectToField;
    private final String asField;
    private final Integer maxDepth;
    private final String depthField;
    private final MongoCollection<?> collection;

    public GraphLookupStage(Document configuration, MongoDatabase mongoDatabase) {
        String from = this.readStringConfigurationProperty(configuration, "from");
        this.collection = mongoDatabase.resolveCollection(from, false);
        this.readStringConfigurationProperty(configuration, "from");
        this.readVariableConfigurationProperty(configuration, START_WITH);
        this.connectFromField = this.readStringConfigurationProperty(configuration, CONNECT_FROM_FIELD);
        this.connectToField = this.readStringConfigurationProperty(configuration, CONNECT_TO_FIELD);
        this.asField = this.readStringConfigurationProperty(configuration, "as");
        this.maxDepth = this.readOptionalIntegerConfigurationProperty(configuration, MAX_DEPTH);
        this.depthField = this.readOptionalStringConfigurationProperty(configuration, DEPTH_FIELD);
        this.ensureAllConfigurationPropertiesAreKnown(configuration, CONFIGURATION_KEYS);
    }

    @Override
    public String name() {
        return "$graphLookup";
    }

    Integer readOptionalIntegerConfigurationProperty(Document configuration, String name) {
        Object value = configuration.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new FailedToParseException("'" + name + "' option to \" + stageName + \" must be a integer, but was type " + Utils.describeType(value));
    }

    String readOptionalStringConfigurationProperty(Document configuration, String name) {
        Object value = configuration.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw new FailedToParseException("'" + name + "' option to \" + stageName + \" must be a string, but was type " + Utils.describeType(value));
    }

    void readVariableConfigurationProperty(Document configuration, String name) {
        Object value = configuration.get(name);
        if (value == null) {
            throw new FailedToParseException("missing '" + name + "' option to $graphLookup stage specification: " + String.valueOf(configuration));
        }
        if (value instanceof String) {
            return;
        }
        throw new FailedToParseException("'" + name + "' option to $graphLookup must be a string, but was type " + Utils.describeType(value));
    }

    @Override
    public Stream<Document> apply(Stream<Document> stream) {
        return stream.map(this::connectRemoteDocument);
    }

    private Document connectRemoteDocument(Document document) {
        Object value = document.get(this.connectFromField);
        ArrayList<Document> documentList = new ArrayList<Document>();
        this.findLinkedDocuments(0L, documentList, value);
        Document result = document.clone();
        result.put(this.asField, (Object)documentList);
        return result;
    }

    private List<Document> findLinkedDocuments(long depth, List<Document> linked, Object value) {
        if (this.maxDepth != null && depth > (long)this.maxDepth.intValue()) {
            return linked;
        }
        if (value instanceof List) {
            return ((List)value).stream().flatMap(item -> this.findLinkedDocuments(depth + 1L, linked, item).stream()).collect(Collectors.toList());
        }
        Document query = new Document(this.connectToField, value);
        List newlyLinkedDocuments = this.collection.handleQueryAsStream(query).collect(Collectors.toList());
        for (Document newDocument : newlyLinkedDocuments) {
            Object newValue = newDocument.get(this.connectFromField);
            if (this.depthField != null) {
                newDocument.put(this.depthField, (Object)depth);
            }
            linked.add(0, newDocument);
            this.findLinkedDocuments(depth + 1L, linked, newValue);
        }
        return linked;
    }

    static {
        CONFIGURATION_KEYS.add("from");
        CONFIGURATION_KEYS.add(START_WITH);
        CONFIGURATION_KEYS.add(CONNECT_FROM_FIELD);
        CONFIGURATION_KEYS.add(CONNECT_TO_FIELD);
        CONFIGURATION_KEYS.add("as");
        CONFIGURATION_KEYS.add(MAX_DEPTH);
        CONFIGURATION_KEYS.add(DEPTH_FIELD);
    }
}

