/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.bson;

import de.bwaldvogel.mongo.backend.Assert;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Objects;

public final class Decimal128
extends Number
implements Serializable,
Comparable<Decimal128> {
    private static final long serialVersionUID = 1L;
    public static final Decimal128 ONE = new Decimal128(1L, 0x3040000000000000L);
    public static final Decimal128 TWO = new Decimal128(2L, 0x3040000000000000L);
    public static final Decimal128 NaN = new Decimal128(0L, 0x7C00000000000000L);
    public static final Decimal128 POSITIVE_ZERO = new Decimal128(0L, 0x3040000000000000L);
    public static final Decimal128 NEGATIVE_ZERO = new Decimal128(0L, -5746593124524752896L);
    public static final Decimal128 POSITIVE_INFINITY = new Decimal128(0L, 0x7800000000000000L);
    public static final Decimal128 NEGATIVE_INFINITY = new Decimal128(0L, -576460752303423488L);
    private static final BigInteger BIG_INT_TEN = new BigInteger("10");
    private static final BigInteger BIG_INT_ONE = new BigInteger("1");
    private static final BigInteger BIG_INT_ZERO = new BigInteger("0");
    private static final long INFINITY_MASK = 0x7800000000000000L;
    private static final long NaN_MASK = 0x7C00000000000000L;
    private static final long SIGN_BIT_MASK = Long.MIN_VALUE;
    private static final int MIN_EXPONENT = -6176;
    private static final int MAX_EXPONENT = 6111;
    private static final int EXPONENT_OFFSET = 6176;
    private static final int MAX_BIT_LENGTH = 113;
    private final long low;
    private final long high;

    public Decimal128(long low, long high) {
        this.low = low;
        this.high = high;
    }

    public Decimal128(BigDecimal value) {
        this(value, value.signum() == -1);
    }

    public static Decimal128 fromNumber(Number value) {
        if (value instanceof Decimal128) {
            return (Decimal128)value;
        }
        if (value instanceof Long || value instanceof Integer || value instanceof Short) {
            return new Decimal128(BigDecimal.valueOf(value.longValue()));
        }
        return new Decimal128(BigDecimal.valueOf(value.doubleValue()));
    }

    private Decimal128(BigDecimal initialValue, boolean isNegative) {
        int i;
        long localHigh = 0L;
        long localLow = 0L;
        BigDecimal value = this.clampAndRound(initialValue);
        long exponent = -value.scale();
        if (exponent < -6176L || exponent > 6111L) {
            throw new AssertionError((Object)("Exponent is out of range for Decimal128 encoding: " + exponent));
        }
        if (value.unscaledValue().bitLength() > 113) {
            throw new AssertionError((Object)("Unscaled roundedValue is out of range for Decimal128 encoding:" + String.valueOf(value.unscaledValue())));
        }
        BigInteger significand = value.unscaledValue().abs();
        int bitLength = significand.bitLength();
        for (i = 0; i < Math.min(64, bitLength); ++i) {
            if (!significand.testBit(i)) continue;
            localLow |= 1L << i;
        }
        for (i = 64; i < bitLength; ++i) {
            if (!significand.testBit(i)) continue;
            localHigh |= 1L << i - 64;
        }
        long biasedExponent = exponent + 6176L;
        localHigh |= biasedExponent << 49;
        if (value.signum() == -1 || isNegative) {
            localHigh |= Long.MIN_VALUE;
        }
        this.high = localHigh;
        this.low = localLow;
    }

    public long getLow() {
        return this.low;
    }

    public long getHigh() {
        return this.high;
    }

    public BigDecimal toBigDecimal() {
        Assert.isFalse(this.isSpecial(), () -> String.valueOf(this) + " cannot be converted to BigDecimal");
        return this.toBigDecimalValue();
    }

    private BigDecimal toBigDecimalValue() {
        int scale = -this.getExponent();
        if (this.twoHighestCombinationBitsAreSet()) {
            return BigDecimal.valueOf(0L, scale);
        }
        return new BigDecimal(new BigInteger(this.isNegative() ? -1 : 1, this.getBytes()), scale);
    }

    private byte[] getBytes() {
        int i;
        byte[] bytes = new byte[15];
        long mask = 255L;
        for (i = 14; i >= 7; --i) {
            bytes[i] = (byte)((this.low & mask) >>> (14 - i << 3));
            mask <<= 8;
        }
        mask = 255L;
        for (i = 6; i >= 1; --i) {
            bytes[i] = (byte)((this.high & mask) >>> (6 - i << 3));
            mask <<= 8;
        }
        mask = 0x1000000000000L;
        bytes[0] = (byte)((this.high & mask) >>> 48);
        return bytes;
    }

    private int getExponent() {
        if (this.twoHighestCombinationBitsAreSet()) {
            return (int)((this.high & 0x1FFFE00000000000L) >>> 47) - 6176;
        }
        return (int)((this.high & 0x7FFF800000000000L) >>> 49) - 6176;
    }

    private boolean twoHighestCombinationBitsAreSet() {
        return (this.high & 0x6000000000000000L) == 0x6000000000000000L;
    }

    private boolean isNegative() {
        return (this.high & Long.MIN_VALUE) == Long.MIN_VALUE;
    }

    private boolean isInfinite() {
        return (this.high & 0x7800000000000000L) == 0x7800000000000000L;
    }

    private boolean isNaN() {
        return (this.high & 0x7C00000000000000L) == 0x7C00000000000000L;
    }

    public String toString() {
        if (this.isNaN()) {
            return "NaN";
        }
        if (this.isInfinite()) {
            return this.isNegative() ? "-Infinity" : "Infinity";
        }
        return (this.isNegative() ? "-" : "") + this.toStringWithBigDecimal();
    }

    private String toStringWithBigDecimal() {
        BigDecimal bigDecimal = this.toBigDecimalValue();
        String significand = bigDecimal.unscaledValue().abs().toString();
        int exponent = -bigDecimal.scale();
        int adjustedExponent = exponent + significand.length() - 1;
        if (exponent <= 0 && adjustedExponent >= -6) {
            return this.toNormalString(significand, exponent);
        }
        return this.toScientificString(significand, adjustedExponent);
    }

    private String toNormalString(String significand, int exponent) {
        StringBuilder builder = new StringBuilder();
        if (exponent == 0) {
            builder.append(significand);
        } else {
            int pad = -exponent - significand.length();
            if (pad >= 0) {
                builder.append('0');
                builder.append('.');
                for (int i = 0; i < pad; ++i) {
                    builder.append('0');
                }
                builder.append(significand, 0, significand.length());
            } else {
                builder.append(significand, 0, -pad);
                builder.append('.');
                builder.append(significand, -pad, -pad - exponent);
            }
        }
        return builder.toString();
    }

    private String toScientificString(String significand, int adjustedExponent) {
        StringBuilder builder = new StringBuilder();
        builder.append(significand.charAt(0));
        if (significand.length() > 1) {
            builder.append('.');
            builder.append(significand, 1, significand.length());
        }
        builder.append('E');
        if (adjustedExponent > 0) {
            builder.append('+');
        }
        builder.append(adjustedExponent);
        return builder.toString();
    }

    @Override
    public int intValue() {
        return this.toBigDecimal().intValue();
    }

    @Override
    public long longValue() {
        return this.toBigDecimal().intValue();
    }

    @Override
    public float floatValue() {
        if (this.isNaN()) {
            return Float.NaN;
        }
        if (this.isInfinite()) {
            return this.isNegative() ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        return this.toBigDecimal().floatValue();
    }

    @Override
    public double doubleValue() {
        if (this.isNaN()) {
            return Double.NaN;
        }
        if (this.isInfinite()) {
            return this.isNegative() ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        return this.toBigDecimal().doubleValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Decimal128 that = (Decimal128)o;
        return this.getLow() == that.getLow() && this.getHigh() == that.getHigh();
    }

    public int hashCode() {
        return Objects.hash(this.getLow(), this.getHigh());
    }

    @Override
    public int compareTo(Decimal128 o) {
        if (this.isSpecial() || o.isSpecial()) {
            return Double.compare(this.doubleValue(), o.doubleValue());
        }
        return this.toBigDecimal().compareTo(o.toBigDecimal());
    }

    private boolean isSpecial() {
        return this.isNaN() || this.isInfinite();
    }

    private BigDecimal clampAndRound(BigDecimal initialValue) {
        if (-initialValue.scale() > 6111) {
            int diff = -initialValue.scale() - 6111;
            if (initialValue.unscaledValue().equals(BIG_INT_ZERO)) {
                return new BigDecimal(initialValue.unscaledValue(), -6111);
            }
            if (diff + initialValue.precision() > 34) {
                throw new NumberFormatException("Exponent is out of range for Decimal128 encoding of " + String.valueOf(initialValue));
            }
            BigInteger multiplier = BIG_INT_TEN.pow(diff);
            return new BigDecimal(initialValue.unscaledValue().multiply(multiplier), initialValue.scale() + diff);
        }
        if (-initialValue.scale() < -6176) {
            int diff = initialValue.scale() + -6176;
            int undiscardedPrecision = this.ensureExactRounding(initialValue, diff);
            BigInteger divisor = undiscardedPrecision == 0 ? BIG_INT_ONE : BIG_INT_TEN.pow(diff);
            return new BigDecimal(initialValue.unscaledValue().divide(divisor), initialValue.scale() - diff);
        }
        BigDecimal roundedValue = initialValue.round(MathContext.DECIMAL128);
        int extraPrecision = initialValue.precision() - roundedValue.precision();
        if (extraPrecision > 0) {
            this.ensureExactRounding(initialValue, extraPrecision);
        }
        return roundedValue;
    }

    private int ensureExactRounding(BigDecimal initialValue, int extraPrecision) {
        int undiscardedPrecision;
        String significand = initialValue.unscaledValue().abs().toString();
        for (int i = undiscardedPrecision = Math.max(0, significand.length() - extraPrecision); i < significand.length(); ++i) {
            if (significand.charAt(i) == '0') continue;
            throw new NumberFormatException("Conversion to Decimal128 would require inexact rounding of " + String.valueOf(initialValue));
        }
        return undiscardedPrecision;
    }
}

