/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.wire;

import de.bwaldvogel.mongo.backend.Assert;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.wire.MessageFlag;
import de.bwaldvogel.mongo.wire.OpCode;
import de.bwaldvogel.mongo.wire.QueryFlag;
import de.bwaldvogel.mongo.wire.bson.BsonDecoder;
import de.bwaldvogel.mongo.wire.message.ClientRequest;
import de.bwaldvogel.mongo.wire.message.MessageHeader;
import de.bwaldvogel.mongo.wire.message.MongoMessage;
import de.bwaldvogel.mongo.wire.message.MongoQuery;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoWireProtocolHandler
extends LengthFieldBasedFrameDecoder {
    private static final Logger log = LoggerFactory.getLogger(MongoWireProtocolHandler.class);
    public static final int MAX_MESSAGE_SIZE_BYTES = 48000000;
    public static final int MAX_WRITE_BATCH_SIZE = 1000;
    private static final int MAX_FRAME_LENGTH = Integer.MAX_VALUE;
    private static final int LENGTH_FIELD_OFFSET = 0;
    private static final int LENGTH_FIELD_LENGTH = 4;
    private static final int LENGTH_ADJUSTMENT = -4;
    private static final int INITIAL_BYTES_TO_STRIP = 0;
    private static final int CHECKSUM_LENGTH = 4;

    public MongoWireProtocolHandler() {
        super(Integer.MAX_VALUE, 0, 4, -4, 0);
    }

    protected ClientRequest decode(ChannelHandlerContext ctx, ByteBuf buf) throws Exception {
        ByteBuf in = buf;
        if (in.readableBytes() < 4) {
            return null;
        }
        in.markReaderIndex();
        int totalLength = in.readIntLE();
        if (totalLength > 48000000) {
            throw new IOException("message too large: " + totalLength + " bytes");
        }
        if (in.readableBytes() < totalLength - 4) {
            in.resetReaderIndex();
            return null;
        }
        in = in.readSlice(totalLength - 4);
        long readable = in.readableBytes();
        Assert.equals(readable, totalLength - 4);
        int requestID = in.readIntLE();
        int responseTo = in.readIntLE();
        MessageHeader header = new MessageHeader(totalLength, requestID, responseTo);
        int opCodeId = in.readIntLE();
        OpCode opCode = OpCode.getById(opCodeId);
        if (opCode == null) {
            throw new IOException("opCode " + opCodeId + " not supported");
        }
        Channel channel = ctx.channel();
        ClientRequest request = switch (opCode) {
            case OpCode.OP_QUERY -> this.handleQuery(channel, header, in);
            case OpCode.OP_MSG -> this.handleMessage(channel, header, in);
            default -> throw new UnsupportedOperationException("unsupported opcode: " + String.valueOf((Object)opCode));
        };
        if (in.isReadable()) {
            throw new IOException();
        }
        log.debug("{}", (Object)request);
        return request;
    }

    private ClientRequest handleQuery(Channel channel, MessageHeader header, ByteBuf buffer) {
        int flags = buffer.readIntLE();
        String fullCollectionName = BsonDecoder.decodeCString(buffer);
        int numberToSkip = buffer.readIntLE();
        int numberToReturn = buffer.readIntLE();
        Document query = BsonDecoder.decodeBson(buffer);
        Document returnFieldSelector = null;
        if (buffer.isReadable()) {
            returnFieldSelector = BsonDecoder.decodeBson(buffer);
        }
        MongoQuery mongoQuery = new MongoQuery(channel, header, fullCollectionName, numberToSkip, numberToReturn, query, returnFieldSelector);
        if (QueryFlag.SLAVE_OK.isSet(flags)) {
            flags = QueryFlag.SLAVE_OK.removeFrom(flags);
        }
        if (QueryFlag.NO_CURSOR_TIMEOUT.isSet(flags)) {
            flags = QueryFlag.NO_CURSOR_TIMEOUT.removeFrom(flags);
        }
        if (flags != 0) {
            throw new UnsupportedOperationException("flags=" + flags + " not yet supported");
        }
        log.debug("query {} from {}", (Object)query, (Object)fullCollectionName);
        return mongoQuery;
    }

    private ClientRequest handleMessage(Channel channel, MessageHeader header, ByteBuf buffer) {
        int flagBits = buffer.readIntLE();
        EnumSet<MessageFlag> flags = EnumSet.noneOf(MessageFlag.class);
        if (MessageFlag.CHECKSUM_PRESENT.isSet(flagBits)) {
            flagBits = MessageFlag.CHECKSUM_PRESENT.removeFrom(flagBits);
            flags.add(MessageFlag.CHECKSUM_PRESENT);
        }
        if (flagBits != 0) {
            throw new UnsupportedOperationException("flags=" + flagBits + " not yet supported");
        }
        int expectedPayloadSize = header.getTotalLength() - 4;
        if (flags.contains((Object)MessageFlag.CHECKSUM_PRESENT)) {
            expectedPayloadSize -= 4;
        }
        Document body = null;
        Document documentSequence = new Document();
        block4: while (buffer.readerIndex() < expectedPayloadSize) {
            byte sectionKind = buffer.readByte();
            switch (sectionKind) {
                case 0: {
                    Assert.isNull(body);
                    body = BsonDecoder.decodeBson(buffer);
                    continue block4;
                }
                case 1: {
                    this.decodeKindDocumentSequence(buffer, documentSequence);
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unexpected section kind: " + sectionKind);
        }
        if (flags.contains((Object)MessageFlag.CHECKSUM_PRESENT)) {
            int checksum = buffer.readIntLE();
            log.trace("Ignoring checksum {}", (Object)checksum);
        }
        Assert.notNull(body);
        for (Map.Entry<String, Object> entry : documentSequence.entrySet()) {
            Object old = body.put(entry.getKey(), entry.getValue());
            Assert.isNull(old);
        }
        return new MongoMessage(channel, header, body);
    }

    private void decodeKindDocumentSequence(ByteBuf buffer, Document documentSequence) {
        int readerStartOffset = buffer.readerIndex();
        int sectionSize = buffer.readIntLE();
        String documentIdentifier = BsonDecoder.decodeCString(buffer);
        ArrayList<Document> documents = new ArrayList<Document>();
        do {
            Document subDocument = BsonDecoder.decodeBson(buffer);
            documents.add(subDocument);
        } while (buffer.readerIndex() - readerStartOffset < sectionSize);
        Assert.notEmpty(documents);
        Object old = documentSequence.put(documentIdentifier, (Object)documents);
        Assert.isNull(old);
    }
}

