/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.wire;

import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.wire.OpCode;
import de.bwaldvogel.mongo.wire.bson.BsonEncoder;
import de.bwaldvogel.mongo.wire.message.MongoReply;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoWireReplyEncoder
extends MessageToByteEncoder<MongoReply> {
    private static final Logger log = LoggerFactory.getLogger(MongoWireReplyEncoder.class);

    protected void encode(ChannelHandlerContext ctx, MongoReply reply, ByteBuf buf) {
        buf.writeIntLE(0);
        buf.writeIntLE(reply.getHeader().getRequestID());
        buf.writeIntLE(reply.getHeader().getResponseTo());
        buf.writeIntLE(OpCode.OP_REPLY.getId());
        buf.writeIntLE(reply.getFlags());
        buf.writeLongLE(reply.getCursorId());
        buf.writeIntLE(reply.getStartingFrom());
        List<Document> documents = reply.getDocuments();
        buf.writeIntLE(documents.size());
        for (Document document : documents) {
            try {
                BsonEncoder.encodeDocument(document, buf);
            }
            catch (RuntimeException e) {
                log.error("Failed to encode {}", (Object)document, (Object)e);
                ctx.channel().close();
                throw e;
            }
        }
        log.debug("wrote reply: {}", (Object)reply);
        int writerIndex = buf.writerIndex();
        buf.setIntLE(0, writerIndex);
    }
}

