/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.tools.jar;

import com.googlecode.d2j.util.AccUtils;
import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class InitOut {
    private static final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"));
    private int clzIndex = 0;
    private final Set<String> clzMap = new TreeSet<String>();
    private final Set<String> clzSet = new TreeSet<String>();
    private Path from;
    private int maxLength = 40;
    private final Set<String> memberMap = new TreeSet<String>();
    private int minLength = 2;
    private int pkgIndex = 0;
    private final Set<String> pkgMap = new TreeSet<String>();
    private final Set<String> pkgSet = new TreeSet<String>();
    private boolean initEnumNames = false;
    private boolean initSourceNames = false;
    private boolean initAssertionNames = false;

    public InitOut initEnumNames() {
        this.initEnumNames = true;
        return this;
    }

    public InitOut initSourceNames() {
        this.initSourceNames = true;
        return this;
    }

    public InitOut initAssertionNames() {
        this.initAssertionNames = true;
        return this;
    }

    private void doClass0(String clz) {
        if (this.clzSet.contains(clz)) {
            return;
        }
        this.clzSet.add(clz);
        int index = clz.lastIndexOf(36);
        if (index > 0) {
            this.doClass0(clz.substring(0, index));
            String cName = clz.substring(index + 1);
            try {
                Integer.parseInt(cName);
            }
            catch (Exception ex) {
                if (this.shouldRename(cName)) {
                    this.clzMap.add(String.format("c %s=CI%03d%s", clz, this.clzIndex++, this.short4LongName(cName)));
                }
            }
        } else {
            index = clz.lastIndexOf(47);
            if (index > 0) {
                this.doPkg(clz.substring(0, index));
                String cName = clz.substring(index + 1);
                if (this.shouldRename(cName)) {
                    this.clzMap.add(String.format("c %s=C%03d%s", clz, this.clzIndex++, this.short4LongName(cName)));
                }
            } else if (this.shouldRename(clz)) {
                this.clzMap.add(String.format("c %s=CI_%03d%s", clz, this.clzIndex++, this.short4LongName(clz)));
            }
        }
    }

    private String short4LongName(String name) {
        if (name.length() > this.maxLength) {
            return "x" + Integer.toHexString(name.hashCode());
        }
        return name;
    }

    private void doMember(String owner, MemberInfo member, int x) {
        if (x > 0 || this.shouldRename(member.name)) {
            if (member.desc.indexOf(40) >= 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(AccUtils.isStatic(member.access) ? "M" : "m");
                if (AccUtils.isPrivate(member.access)) {
                    sb.append("p");
                } else if (AccUtils.isPublic(member.access)) {
                    sb.append("P");
                }
                if (x > 0) {
                    sb.append(x);
                }
                sb.append(this.short4LongName(member.name));
                if (x > 0) {
                    this.memberMap.add("m " + owner + "." + member.name + member.desc + "=" + sb);
                } else {
                    this.memberMap.add("m " + owner + "." + member.name + member.desc.substring(0, member.desc.indexOf(41) + 1) + "=" + sb);
                }
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append(AccUtils.isStatic(member.access) ? "F" : "f");
                if (AccUtils.isPrivate(member.access)) {
                    sb.append("p");
                } else if (AccUtils.isPublic(member.access)) {
                    sb.append("P");
                }
                if (x > 0) {
                    sb.append(x);
                }
                sb.append(this.short4LongName(member.name));
                if (x > 0) {
                    this.memberMap.add("m " + owner + "." + member.name + "[" + member.desc + "]=" + sb);
                } else {
                    this.memberMap.add("m " + owner + "." + member.name + "=" + sb);
                }
            }
        }
    }

    private List<ClassInfo> collect(Path file) throws IOException {
        final ArrayList<ClassInfo> clzList = new ArrayList<ClassInfo>();
        ClassVisitor collectVisitor = new ClassVisitor(589824){
            private static final String ASSERTION_DISABLED_FIELD_NAME = "$assertionsDisabled";
            private static final String ENUM_VALUES_FIELD_NAME = "ENUM$VALUES";
            ClassInfo clz;
            boolean isEnum;
            final Map<String, String> enumFieldMap;
            {
                super(arg0);
                this.isEnum = false;
                this.enumFieldMap = new HashMap<String, String>();
            }

            public void visitSource(String source, String debug) {
                if (InitOut.this.initSourceNames && !this.clz.name.contains("$") && source.endsWith(".java")) {
                    this.clz.suggestName = source.substring(0, source.length() - 5);
                }
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                this.clz.addMethod(access, name, desc);
                if (InitOut.this.initEnumNames && this.isEnum && name.equals("<clinit>")) {
                    final String thisDesc = "L" + this.clz.name + ";";
                    return new MethodNode(589824, access, name, desc, signature, exceptions){

                        public void visitEnd() {
                            if (this.instructions != null) {
                                int status = 0;
                                String eFieldName = null;
                                for (AbstractInsnNode p = this.instructions.getFirst(); p != null; p = p.getNext()) {
                                    if (status == 0) {
                                        if (p.getOpcode() != 187) continue;
                                        TypeInsnNode ti = (TypeInsnNode)p;
                                        if (!thisDesc.equals(ti.desc)) continue;
                                        status = 1;
                                        continue;
                                    }
                                    if (status == 1) {
                                        if (p.getOpcode() == 89) {
                                            status = 2;
                                            continue;
                                        }
                                        status = 0;
                                        continue;
                                    }
                                    if (status == 2) {
                                        if (p.getOpcode() == 18) {
                                            LdcInsnNode ldc = (LdcInsnNode)p;
                                            if (ldc.cst instanceof String) {
                                                eFieldName = (String)ldc.cst;
                                                status = 3;
                                                continue;
                                            }
                                            status = 0;
                                            continue;
                                        }
                                        status = 0;
                                        continue;
                                    }
                                    if (p.getOpcode() != 179) continue;
                                    FieldInsnNode fin = (FieldInsnNode)p;
                                    if (!fin.owner.equals(thisDesc) || !fin.desc.equals(thisDesc)) continue;
                                    if (!fin.name.equals(eFieldName)) {
                                        enumFieldMap.put(fin.name, eFieldName);
                                    }
                                    eFieldName = null;
                                    status = 0;
                                }
                            }
                        }
                    };
                }
                return null;
            }

            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                MemberInfo mi = this.clz.addField(access, name, desc);
                if (InitOut.this.initEnumNames && this.isEnum && AccUtils.isPrivate(access) && AccUtils.isFinal(access) && AccUtils.isSynthetic(access) && !ENUM_VALUES_FIELD_NAME.equals(name) && ("[L" + this.clz.name + ";").equals(desc)) {
                    mi.suggestName = ENUM_VALUES_FIELD_NAME;
                }
                if (InitOut.this.initAssertionNames && AccUtils.isSynthetic(access) && AccUtils.isStatic(access) && !AccUtils.isPrivate(access) && !AccUtils.isPublic(access) && !AccUtils.isProtected(access) && desc.equals("Z") && !ASSERTION_DISABLED_FIELD_NAME.equals(name)) {
                    mi.suggestName = ASSERTION_DISABLED_FIELD_NAME;
                }
                return null;
            }

            public void visitEnd() {
                if (InitOut.this.initEnumNames) {
                    String thisDesc = "L" + this.clz.name + ";";
                    for (Map.Entry<String, String> e : this.enumFieldMap.entrySet()) {
                        String name = e.getKey();
                        String suggestName = e.getValue();
                        for (MemberInfo mi : this.clz.fields) {
                            if (!AccUtils.isFinal(mi.access) || !AccUtils.isStatic(mi.access) || !mi.name.equals(name) || !mi.desc.equals(thisDesc)) continue;
                            mi.suggestName = suggestName;
                        }
                    }
                }
                clzList.add(this.clz);
                this.clz = null;
                this.isEnum = false;
                this.enumFieldMap.clear();
            }

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.clz = new ClassInfo(name);
                this.isEnum = AccUtils.isEnum(access);
            }
        };
        try (FileSystem fs = BaseCmd.openZip((Path)file);){
            BaseCmd.walkJarOrDir((Path)fs.getPath("/", new String[0]), (file1, relative) -> {
                if (relative.endsWith(".class")) {
                    byte[] data = Files.readAllBytes(file1);
                    new ClassReader(data).accept(collectVisitor, 8);
                }
            });
        }
        return clzList;
    }

    private void doPkg(String pkg) {
        if (this.pkgSet.contains(pkg)) {
            return;
        }
        this.pkgSet.add(pkg);
        int index = pkg.lastIndexOf(47);
        if (index > 0) {
            this.doPkg(pkg.substring(0, index));
            String cName = pkg.substring(index + 1);
            if (this.shouldRename(cName)) {
                this.pkgMap.add(String.format("p %s=p%02d%s", pkg, this.pkgIndex++, this.short4LongName(cName)));
            }
        } else if (this.shouldRename(pkg)) {
            this.pkgMap.add(String.format("p %s=p%02d%s", pkg, this.pkgIndex++, this.short4LongName(pkg)));
        }
    }

    public InitOut from(Path from) {
        this.from = from;
        return this;
    }

    public InitOut maxLength(int m) {
        this.maxLength = m;
        return this;
    }

    public InitOut minLength(int m) {
        this.minLength = m;
        return this;
    }

    private boolean shouldRename(String s) {
        return s.length() > this.maxLength || s.length() < this.minLength || KEYWORDS.contains(s);
    }

    public void to(Path config) throws IOException {
        List<ClassInfo> classInfoList = this.collect(this.from);
        this.transform(classInfoList);
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.pkgMap);
        list.addAll(this.clzMap);
        list.addAll(this.memberMap);
        Files.write(config, list, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private void transformerMember(String owner, List<MemberInfo> members) {
        block4: {
            Iterator<MemberInfo> it = members.iterator();
            if (!it.hasNext()) break block4;
            MemberInfo current = it.next();
            block0: while (it.hasNext()) {
                MemberInfo next = it.next();
                if (current.name.equals(next.name)) {
                    int x = 1;
                    this.doMember(owner, current, x++);
                    this.doMember(owner, next, x++);
                    while (it.hasNext()) {
                        next = it.next();
                        if (current.name.equals(next.name)) {
                            this.doMember(owner, next, x++);
                            continue;
                        }
                        current = next;
                        continue block0;
                    }
                    continue;
                }
                this.doMember(owner, current, 0);
                current = next;
            }
            this.doMember(owner, current, 0);
        }
    }

    private void transform(List<ClassInfo> classInfoList) {
        MemberInfoComparator comparator = new MemberInfoComparator();
        for (ClassInfo ci : classInfoList) {
            this.doClass0(ci.name);
            ci.fields.sort(comparator);
            this.transformerMember(ci.name, ci.fields);
            ci.methods.sort(comparator);
            this.transformerMember(ci.name, ci.methods);
        }
    }

    private static class MemberInfoComparator
    implements Comparator<MemberInfo>,
    Serializable {
        private MemberInfoComparator() {
        }

        @Override
        public int compare(MemberInfo memberInfo, MemberInfo memberInfo2) {
            int x = memberInfo.name.compareTo(memberInfo2.name);
            if (x != 0) {
                return x;
            }
            return memberInfo.desc.compareTo(memberInfo2.desc);
        }
    }

    private static class MemberInfo {
        public int access;
        public String desc;
        public String name;
        public String suggestName;

        MemberInfo(int access, String name, String desc) {
            this.name = name;
            this.access = access;
            this.desc = desc;
        }
    }

    private static class ClassInfo {
        public final String name;
        public List<MemberInfo> fields = new ArrayList<MemberInfo>(5);
        public List<MemberInfo> methods = new ArrayList<MemberInfo>(5);
        public String suggestName;

        ClassInfo(String name) {
            this.name = name;
        }

        public MemberInfo addField(int access, String name, String type) {
            MemberInfo mi = new MemberInfo(access, name, type);
            this.fields.add(mi);
            return mi;
        }

        public MemberInfo addMethod(int access, String name, String desc) {
            MemberInfo mi = new MemberInfo(access, name, desc);
            this.methods.add(mi);
            return mi;
        }

        public String toString() {
            return this.name;
        }
    }
}

