package de.flapdoodle.os.common.attributes;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TextFile}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTextFile.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableTextFile.of()}.
 */
@Generated(from = "TextFile", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableTextFile implements TextFile {
  private final String name;
  private final Charset charset;

  private ImmutableTextFile(String name) {
    this.name = Objects.requireNonNull(name, "name");
    this.charset = Objects.requireNonNull(TextFile.super.charset(), "charset");
  }

  private ImmutableTextFile(ImmutableTextFile.Builder builder) {
    this.name = builder.name;
    this.charset = builder.charset != null
        ? builder.charset
        : Objects.requireNonNull(TextFile.super.charset(), "charset");
  }

  private ImmutableTextFile(String name, Charset charset) {
    this.name = name;
    this.charset = charset;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code charset} attribute
   */
  @Override
  public Charset charset() {
    return charset;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TextFile#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTextFile withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableTextFile(newValue, this.charset);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TextFile#charset() charset} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for charset
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTextFile withCharset(Charset value) {
    if (this.charset == value) return this;
    Charset newValue = Objects.requireNonNull(value, "charset");
    return new ImmutableTextFile(this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTextFile} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTextFile
        && equalTo(0, (ImmutableTextFile) another);
  }

  private boolean equalTo(int synthetic, ImmutableTextFile another) {
    return name.equals(another.name)
        && charset.equals(another.charset);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code charset}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + charset.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TextFile} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TextFile{"
        + "name=" + name
        + ", charset=" + charset
        + "}";
  }

  /**
   * Construct a new immutable {@code TextFile} instance.
   * @param name The value for the {@code name} attribute
   * @return An immutable TextFile instance
   */
  public static ImmutableTextFile of(String name) {
    return new ImmutableTextFile(name);
  }

  /**
   * Creates an immutable copy of a {@link TextFile} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TextFile instance
   */
  public static ImmutableTextFile copyOf(TextFile instance) {
    if (instance instanceof ImmutableTextFile) {
      return (ImmutableTextFile) instance;
    }
    return ImmutableTextFile.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTextFile ImmutableTextFile}.
   * <pre>
   * ImmutableTextFile.builder()
   *    .name(String) // required {@link TextFile#name() name}
   *    .charset(java.nio.charset.Charset) // optional {@link TextFile#charset() charset}
   *    .build();
   * </pre>
   * @return A new ImmutableTextFile builder
   */
  public static ImmutableTextFile.Builder builder() {
    return new ImmutableTextFile.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTextFile ImmutableTextFile}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TextFile", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private String name;
    private Charset charset;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TextFile} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TextFile instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.name());
      charset(instance.charset());
      return this;
    }

    /**
     * Initializes the value for the {@link TextFile#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link TextFile#charset() charset} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link TextFile#charset() charset}.</em>
     * @param charset The value for charset 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder charset(Charset charset) {
      this.charset = Objects.requireNonNull(charset, "charset");
      return this;
    }

    /**
     * Builds a new {@link ImmutableTextFile ImmutableTextFile}.
     * @return An immutable instance of TextFile
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTextFile build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTextFile(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build TextFile, some of required attributes are not set " + attributes;
    }
  }
}
