/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.os.common.attributes;

import de.flapdoodle.os.common.attributes.Attribute;
import de.flapdoodle.os.common.attributes.AttributeExtractor;
import de.flapdoodle.os.common.attributes.MappedTextFile;
import de.flapdoodle.os.common.attributes.MappedTextFileResolver;
import de.flapdoodle.os.common.attributes.SystemProperty;
import de.flapdoodle.os.common.attributes.SystemPropertyResolver;
import de.flapdoodle.os.common.attributes.TextFile;
import de.flapdoodle.os.common.attributes.TextFileResolver;
import java.util.Optional;
import java.util.function.Predicate;

@FunctionalInterface
public interface AttributeExtractorLookup {
    public <T, A extends Attribute<T>> Optional<AttributeExtractor<T, A>> extractor(A var1);

    default public AttributeExtractorLookup join(final AttributeExtractorLookup other) {
        final AttributeExtractorLookup that = this;
        return new AttributeExtractorLookup(){

            @Override
            public <T, A extends Attribute<T>> Optional<AttributeExtractor<T, A>> extractor(A attribute) {
                Optional first = that.extractor(attribute);
                if (first.isPresent()) {
                    return first;
                }
                return other.extractor(attribute);
            }
        };
    }

    public static <T, A extends Attribute<T>> AttributeExtractorLookup forType(final Class<A> attributeType, final AttributeExtractor<T, A> extractor) {
        return new AttributeExtractorLookup(){

            public <_T, _A extends Attribute<_T>> Optional<AttributeExtractor<_T, _A>> extractor(_A attribute) {
                return attributeType.isInstance(attribute) ? Optional.of(extractor) : Optional.empty();
            }
        };
    }

    public static <T, A extends Attribute<T>> AttributeExtractorLookup with(final Predicate<? super A> attributeTypeCheck, final AttributeExtractor<T, A> extractor) {
        return new AttributeExtractorLookup(){

            public <_T, _A extends Attribute<_T>> Optional<AttributeExtractor<_T, _A>> extractor(_A attribute) {
                return attributeTypeCheck.test(attribute) ? Optional.of(extractor) : Optional.empty();
            }
        };
    }

    public static AttributeExtractorLookup failing() {
        return new AttributeExtractorLookup(){

            @Override
            public <T, A extends Attribute<T>> Optional<AttributeExtractor<T, A>> extractor(A attribute) {
                throw new IllegalArgumentException("no attribute extractor for " + attribute.getClass());
            }
        };
    }

    public static AttributeExtractorLookup systemDefault() {
        return AttributeExtractorLookup.forType(TextFile.class, new TextFileResolver()).join(AttributeExtractorLookup.forType(SystemProperty.class, new SystemPropertyResolver())).join(AttributeExtractorLookup.forType(MappedTextFile.class, new MappedTextFileResolver())).join(AttributeExtractorLookup.failing());
    }
}

