package de.flapdoodle.os.common.attributes;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TypeCheckPredicate}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTypeCheckPredicate.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableTypeCheckPredicate.of()}.
 */
@Generated(from = "TypeCheckPredicate", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableTypeCheckPredicate<T>
    extends TypeCheckPredicate<T> {
  private final Class<T> typeClass;
  private final Predicate<T> check;

  private ImmutableTypeCheckPredicate(Class<T> typeClass, Predicate<T> check) {
    this.typeClass = Objects.requireNonNull(typeClass, "typeClass");
    this.check = Objects.requireNonNull(check, "check");
  }

  private ImmutableTypeCheckPredicate(
      ImmutableTypeCheckPredicate<T> original,
      Class<T> typeClass,
      Predicate<T> check) {
    this.typeClass = typeClass;
    this.check = check;
  }

  /**
   * @return The value of the {@code typeClass} attribute
   */
  @Override
  protected Class<T> typeClass() {
    return typeClass;
  }

  /**
   * @return The value of the {@code check} attribute
   */
  @Override
  protected Predicate<T> check() {
    return check;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TypeCheckPredicate#typeClass() typeClass} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for typeClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTypeCheckPredicate<T> withTypeClass(Class<T> value) {
    if (this.typeClass == value) return this;
    Class<T> newValue = Objects.requireNonNull(value, "typeClass");
    return new ImmutableTypeCheckPredicate<>(this, newValue, this.check);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TypeCheckPredicate#check() check} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for check
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTypeCheckPredicate<T> withCheck(Predicate<T> value) {
    if (this.check == value) return this;
    Predicate<T> newValue = Objects.requireNonNull(value, "check");
    return new ImmutableTypeCheckPredicate<>(this, this.typeClass, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTypeCheckPredicate} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTypeCheckPredicate<?>
        && equalTo((ImmutableTypeCheckPredicate<?>) another);
  }

  private boolean equalTo(ImmutableTypeCheckPredicate<?> another) {
    return typeClass.equals(another.typeClass)
        && check.equals(another.check);
  }

  /**
   * Computes a hash code from attributes: {@code typeClass}, {@code check}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + typeClass.hashCode();
    h += (h << 5) + check.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TypeCheckPredicate} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TypeCheckPredicate{"
        + "typeClass=" + typeClass
        + ", check=" + check
        + "}";
  }

  /**
   * Construct a new immutable {@code TypeCheckPredicate} instance.
 * @param <T> generic parameter T
   * @param typeClass The value for the {@code typeClass} attribute
   * @param check The value for the {@code check} attribute
   * @return An immutable TypeCheckPredicate instance
   */
  public static <T> ImmutableTypeCheckPredicate<T> of(Class<T> typeClass, Predicate<T> check) {
    return new ImmutableTypeCheckPredicate<>(typeClass, check);
  }

  /**
   * Creates an immutable copy of a {@link TypeCheckPredicate} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable TypeCheckPredicate instance
   */
  public static <T> ImmutableTypeCheckPredicate<T> copyOf(TypeCheckPredicate<T> instance) {
    if (instance instanceof ImmutableTypeCheckPredicate<?>) {
      return (ImmutableTypeCheckPredicate<T>) instance;
    }
    return ImmutableTypeCheckPredicate.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTypeCheckPredicate ImmutableTypeCheckPredicate}.
   * <pre>
   * ImmutableTypeCheckPredicate.&amp;lt;T&amp;gt;builder()
   *    .typeClass(Class&amp;lt;T&amp;gt;) // required {@link TypeCheckPredicate#typeClass() typeClass}
   *    .check(function.Predicate&amp;lt;T&amp;gt;) // required {@link TypeCheckPredicate#check() check}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableTypeCheckPredicate builder
   */
  public static <T> ImmutableTypeCheckPredicate.Builder<T> builder() {
    return new ImmutableTypeCheckPredicate.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableTypeCheckPredicate ImmutableTypeCheckPredicate}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TypeCheckPredicate", generator = "Immutables")
  public static final class Builder<T> {
    private static final long INIT_BIT_TYPE_CLASS = 0x1L;
    private static final long INIT_BIT_CHECK = 0x2L;
    private long initBits = 0x3L;

    private Class<T> typeClass;
    private Predicate<T> check;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TypeCheckPredicate} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(TypeCheckPredicate<T> instance) {
      Objects.requireNonNull(instance, "instance");
      typeClass(instance.typeClass());
      check(instance.check());
      return this;
    }

    /**
     * Initializes the value for the {@link TypeCheckPredicate#typeClass() typeClass} attribute.
     * @param typeClass The value for typeClass 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> typeClass(Class<T> typeClass) {
      this.typeClass = Objects.requireNonNull(typeClass, "typeClass");
      initBits &= ~INIT_BIT_TYPE_CLASS;
      return this;
    }

    /**
     * Initializes the value for the {@link TypeCheckPredicate#check() check} attribute.
     * @param check The value for check 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> check(Predicate<T> check) {
      this.check = Objects.requireNonNull(check, "check");
      initBits &= ~INIT_BIT_CHECK;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTypeCheckPredicate ImmutableTypeCheckPredicate}.
     * @return An immutable instance of TypeCheckPredicate
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTypeCheckPredicate<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTypeCheckPredicate<>(null, typeClass, check);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE_CLASS) != 0) attributes.add("typeClass");
      if ((initBits & INIT_BIT_CHECK) != 0) attributes.add("check");
      return "Cannot build TypeCheckPredicate, some of required attributes are not set " + attributes;
    }
  }
}
