package de.flapdoodle.os.common.types;

import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Either}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEither.builder()}.
 */
@Generated(from = "Either", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableEither<L, R> extends Either<L, R> {
  private final L optLeft;
  private final R optRight;

  private ImmutableEither(L optLeft, R optRight) {
    this.optLeft = optLeft;
    this.optRight = optRight;
  }

  /**
   * @return The value of the {@code optLeft} attribute
   */
  @Override
  protected Optional<L> optLeft() {
    return Optional.ofNullable(optLeft);
  }

  /**
   * @return The value of the {@code optRight} attribute
   */
  @Override
  protected Optional<R> optRight() {
    return Optional.ofNullable(optRight);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Either#optLeft() optLeft} attribute.
   * @param value The value for optLeft
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEither<L, R> withOptLeft(L value) {
    L newValue = Objects.requireNonNull(value, "optLeft");
    if (this.optLeft == newValue) return this;
    return validate(new ImmutableEither<>(newValue, this.optRight));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Either#optLeft() optLeft} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for optLeft
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableEither<L, R> withOptLeft(Optional<? extends L> optional) {
    L value = optional.orElse(null);
    if (this.optLeft == value) return this;
    return validate(new ImmutableEither<>(value, this.optRight));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Either#optRight() optRight} attribute.
   * @param value The value for optRight
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEither<L, R> withOptRight(R value) {
    R newValue = Objects.requireNonNull(value, "optRight");
    if (this.optRight == newValue) return this;
    return validate(new ImmutableEither<>(this.optLeft, newValue));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Either#optRight() optRight} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for optRight
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableEither<L, R> withOptRight(Optional<? extends R> optional) {
    R value = optional.orElse(null);
    if (this.optRight == value) return this;
    return validate(new ImmutableEither<>(this.optLeft, value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEither} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEither<?, ?>
        && equalTo(0, (ImmutableEither<?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableEither<?, ?> another) {
    return Objects.equals(optLeft, another.optLeft)
        && Objects.equals(optRight, another.optRight);
  }

  /**
   * Computes a hash code from attributes: {@code optLeft}, {@code optRight}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(optLeft);
    h += (h << 5) + Objects.hashCode(optRight);
    return h;
  }

  /**
   * Prints the immutable value {@code Either} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Either{");
    if (optLeft != null) {
      builder.append("optLeft=").append(optLeft);
    }
    if (optRight != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("optRight=").append(optRight);
    }
    return builder.append("}").toString();
  }

  private static <L, R> ImmutableEither<L, R> validate(ImmutableEither<L, R> instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link Either} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <L> generic parameter L
   * @param <R> generic parameter R
   * @param instance The instance to copy
   * @return A copied immutable Either instance
   */
  public static <L, R> ImmutableEither<L, R> copyOf(Either<L, R> instance) {
    if (instance instanceof ImmutableEither<?, ?>) {
      return (ImmutableEither<L, R>) instance;
    }
    return ImmutableEither.<L, R>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEither ImmutableEither}.
   * <pre>
   * ImmutableEither.&amp;lt;L, R&amp;gt;builder()
   *    .optLeft(L) // optional {@link Either#optLeft() optLeft}
   *    .optRight(R) // optional {@link Either#optRight() optRight}
   *    .build();
   * </pre>
   * @param <L> generic parameter L
   * @param <R> generic parameter R
   * @return A new ImmutableEither builder
   */
  public static <L, R> ImmutableEither.Builder<L, R> builder() {
    return new ImmutableEither.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableEither ImmutableEither}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Either", generator = "Immutables")
  public static final class Builder<L, R> {
    private L optLeft;
    private R optRight;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Either} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R> from(Either<L, R> instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<L> optLeftOptional = instance.optLeft();
      if (optLeftOptional.isPresent()) {
        optLeft(optLeftOptional);
      }
      Optional<R> optRightOptional = instance.optRight();
      if (optRightOptional.isPresent()) {
        optRight(optRightOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link Either#optLeft() optLeft} to optLeft.
     * @param optLeft The value for optLeft
     * @return {@code this} builder for chained invocation
     */
    public final Builder<L, R> optLeft(L optLeft) {
      this.optLeft = Objects.requireNonNull(optLeft, "optLeft");
      return this;
    }

    /**
     * Initializes the optional value {@link Either#optLeft() optLeft} to optLeft.
     * @param optLeft The value for optLeft
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R> optLeft(Optional<? extends L> optLeft) {
      this.optLeft = optLeft.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Either#optRight() optRight} to optRight.
     * @param optRight The value for optRight
     * @return {@code this} builder for chained invocation
     */
    public final Builder<L, R> optRight(R optRight) {
      this.optRight = Objects.requireNonNull(optRight, "optRight");
      return this;
    }

    /**
     * Initializes the optional value {@link Either#optRight() optRight} to optRight.
     * @param optRight The value for optRight
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R> optRight(Optional<? extends R> optRight) {
      this.optRight = optRight.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableEither ImmutableEither}.
     * @return An immutable instance of Either
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEither<L, R> build() {
      return ImmutableEither.validate(new ImmutableEither<>(optLeft, optRight));
    }
  }
}
