/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver.linux;

import de.flapdoodle.embed.mongo.packageresolver.Command;
import de.flapdoodle.embed.mongo.packageresolver.DistributionMatch;
import de.flapdoodle.embed.mongo.packageresolver.HasPlatformMatchRules;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePackageFinderRule;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePackageFinderRules;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinderRule;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinderRules;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatch;
import de.flapdoodle.embed.mongo.packageresolver.UrlTemplatePackageResolver;
import de.flapdoodle.embed.mongo.packageresolver.VersionRange;
import de.flapdoodle.embed.process.config.store.DistributionPackage;
import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.config.store.ImmutableFileSet;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.os.BitSize;
import de.flapdoodle.os.CPUType;
import de.flapdoodle.os.OS;
import de.flapdoodle.os.Version;
import de.flapdoodle.os.linux.UbuntuVersion;
import java.util.Optional;

public class UbuntuPackageResolver
implements PackageFinder,
HasPlatformMatchRules {
    private final Command command;
    private final ImmutablePackageFinderRules rules;

    public UbuntuPackageResolver(Command command) {
        this.command = command;
        this.rules = UbuntuPackageResolver.rules(command);
    }

    @Override
    public PackageFinderRules rules() {
        return this.rules;
    }

    @Override
    public Optional<DistributionPackage> packageFor(Distribution distribution) {
        return this.rules.packageFor(distribution);
    }

    private static PlatformMatch match(BitSize bitSize, CPUType cpuType, UbuntuVersion ... versions) {
        return PlatformMatch.withOs(OS.Linux).withBitSize(bitSize).withCpuType(cpuType).withVersion((Version[])versions);
    }

    private static ImmutablePackageFinderRules rules(Command command) {
        ImmutableFileSet fileSet = FileSet.builder().addEntry(FileType.Executable, command.commandName()).build();
        DistributionMatch ubuntu18xxArmMongoVersions = DistributionMatch.any(VersionRange.of("5.0.5", "5.0.6"), VersionRange.of("5.0.0", "5.0.2"), VersionRange.of("4.4.13", "4.4.13"), VersionRange.of("4.4.11", "4.4.11"), VersionRange.of("4.4.0", "4.4.9"), VersionRange.of("4.2.18", "4.2.19"), VersionRange.of("4.2.5", "4.2.16"), VersionRange.of("4.2.0", "4.2.3"));
        ImmutablePackageFinderRule ubuntu1804arm = PackageFinderRule.builder().match(UbuntuPackageResolver.match(BitSize.B64, CPUType.ARM, UbuntuVersion.Ubuntu_18_04, UbuntuVersion.Ubuntu_18_10, UbuntuVersion.Ubuntu_19_04, UbuntuVersion.Ubuntu_19_10, UbuntuVersion.Ubuntu_20_04, UbuntuVersion.Ubuntu_20_10).andThen(ubuntu18xxArmMongoVersions)).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-aarch64-ubuntu1804-{version}.tgz").build()).build();
        ImmutablePackageFinderRule tools_ubuntu1804arm = PackageFinderRule.builder().match(UbuntuPackageResolver.match(BitSize.B64, CPUType.ARM, UbuntuVersion.Ubuntu_18_04, UbuntuVersion.Ubuntu_18_10, UbuntuVersion.Ubuntu_19_04, UbuntuVersion.Ubuntu_19_10, UbuntuVersion.Ubuntu_20_04, UbuntuVersion.Ubuntu_20_10).andThen(ubuntu18xxArmMongoVersions)).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-ubuntu1804-arm64-{tools.version}.tgz").build()).build();
        DistributionMatch ubuntu18xxMongoVersions = DistributionMatch.any(VersionRange.of("5.0.5", "5.0.6"), VersionRange.of("5.0.0", "5.0.2"), VersionRange.of("4.4.13", "4.4.13"), VersionRange.of("4.4.11", "4.4.11"), VersionRange.of("4.4.0", "4.4.9"), VersionRange.of("4.2.18", "4.2.19"), VersionRange.of("4.2.5", "4.2.16"), VersionRange.of("4.2.0", "4.2.3"), VersionRange.of("4.0.1", "4.0.28"), VersionRange.of("3.6.20", "3.6.23"));
        ImmutablePackageFinderRule ubuntu1804x64 = PackageFinderRule.builder().match(UbuntuPackageResolver.match(BitSize.B64, CPUType.X86, UbuntuVersion.Ubuntu_18_04, UbuntuVersion.Ubuntu_18_10, UbuntuVersion.Ubuntu_19_04, UbuntuVersion.Ubuntu_19_10, UbuntuVersion.Ubuntu_20_04, UbuntuVersion.Ubuntu_20_10, UbuntuVersion.Ubuntu_21_10, UbuntuVersion.Ubuntu_22_04).andThen(ubuntu18xxMongoVersions)).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-ubuntu1804-{version}.tgz").build()).build();
        ImmutablePackageFinderRule tools_ubuntu1804x64 = PackageFinderRule.builder().match(UbuntuPackageResolver.match(BitSize.B64, CPUType.X86, UbuntuVersion.Ubuntu_18_04, UbuntuVersion.Ubuntu_18_10, UbuntuVersion.Ubuntu_19_04, UbuntuVersion.Ubuntu_19_10, UbuntuVersion.Ubuntu_20_04, UbuntuVersion.Ubuntu_20_10).andThen(ubuntu18xxMongoVersions)).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-ubuntu1804-x86_64-{tools.version}.tgz").build()).build();
        DistributionMatch ubuntu20xxMongoVersions = DistributionMatch.any(VersionRange.of("5.0.5", "5.0.6"), VersionRange.of("5.0.0", "5.0.2"), VersionRange.of("4.4.13", "4.4.13"), VersionRange.of("4.4.11", "4.4.11"), VersionRange.of("4.4.0", "4.4.9"));
        ImmutablePackageFinderRule ubuntu20And21arm = PackageFinderRule.builder().match(UbuntuPackageResolver.match(BitSize.B64, CPUType.ARM, UbuntuVersion.Ubuntu_20_04, UbuntuVersion.Ubuntu_20_10, UbuntuVersion.Ubuntu_21_10, UbuntuVersion.Ubuntu_22_04).andThen(ubuntu20xxMongoVersions)).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-aarch64-ubuntu2004-{version}.tgz").build()).build();
        ImmutablePackageFinderRule tools_ubuntu20And21arm = PackageFinderRule.builder().match(UbuntuPackageResolver.match(BitSize.B64, CPUType.ARM, UbuntuVersion.Ubuntu_20_04, UbuntuVersion.Ubuntu_20_10, UbuntuVersion.Ubuntu_21_10, UbuntuVersion.Ubuntu_22_04).andThen(ubuntu20xxMongoVersions)).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-ubuntu2004-arm64-{tools.version}.tgz").build()).build();
        ImmutablePackageFinderRule ubuntu20And21x64 = PackageFinderRule.builder().match(UbuntuPackageResolver.match(BitSize.B64, CPUType.X86, UbuntuVersion.Ubuntu_20_04, UbuntuVersion.Ubuntu_20_10, UbuntuVersion.Ubuntu_21_10, UbuntuVersion.Ubuntu_22_04).andThen(ubuntu20xxMongoVersions)).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-ubuntu2004-{version}.tgz").build()).build();
        ImmutablePackageFinderRule tools_ubuntu20And21x64 = PackageFinderRule.builder().match(UbuntuPackageResolver.match(BitSize.B64, CPUType.X86, UbuntuVersion.Ubuntu_20_04, UbuntuVersion.Ubuntu_20_10, UbuntuVersion.Ubuntu_21_10, UbuntuVersion.Ubuntu_22_04).andThen(ubuntu20xxMongoVersions)).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-ubuntu2004-x86_64-{tools.version}.tgz").build()).build();
        switch (command) {
            case MongoDump: 
            case MongoImport: 
            case MongoRestore: {
                return PackageFinderRules.empty().withRules(tools_ubuntu20And21arm, tools_ubuntu20And21x64, tools_ubuntu1804arm, tools_ubuntu1804x64);
            }
        }
        return PackageFinderRules.empty().withRules(ubuntu20And21arm, ubuntu20And21x64, ubuntu1804arm, ubuntu1804x64);
    }
}

