/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver.linux;

import de.flapdoodle.embed.mongo.packageresolver.HasExplanation;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePlatformMatch;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatch;
import de.flapdoodle.embed.mongo.packageresolver.linux.UbuntuPackageFinder;
import de.flapdoodle.embed.process.config.store.Package;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.os.CommonOS;
import de.flapdoodle.os.ImmutablePlatform;
import de.flapdoodle.os.OS;
import de.flapdoodle.os.Platform;
import de.flapdoodle.os.Version;
import de.flapdoodle.os.linux.DebianVersion;
import de.flapdoodle.os.linux.UbuntuVersion;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Deprecated
public class DebianUsesUbuntuPackageFinder
implements PackageFinder,
HasExplanation {
    private final UbuntuPackageFinder ubuntuPackageFinder;

    public DebianUsesUbuntuPackageFinder(UbuntuPackageFinder ubuntuPackageFinder) {
        this.ubuntuPackageFinder = ubuntuPackageFinder;
    }

    @Override
    public Optional<Package> packageFor(Distribution distribution) {
        if (DebianUsesUbuntuPackageFinder.platformMatch().match(distribution)) {
            if (!distribution.platform().version().isPresent()) {
                throw new RuntimeException("version not set: " + distribution);
            }
            Version currentVersion = (Version)distribution.platform().version().get();
            Optional<UbuntuVersion> ubuntuVersion = DebianUsesUbuntuPackageFinder.matchingUbuntuVersion((DebianVersion)currentVersion);
            if (ubuntuVersion.isPresent()) {
                Distribution asUbuntudistribution = Distribution.of((de.flapdoodle.embed.process.distribution.Version)distribution.version(), (Platform)ImmutablePlatform.copyOf((Platform)distribution.platform()).withVersion(ubuntuVersion));
                return this.ubuntuPackageFinder.packageFor(asUbuntudistribution);
            }
        }
        return Optional.empty();
    }

    @Override
    public String explain() {
        List ubuntuVersions = Stream.of(DebianVersion.DEBIAN_12, DebianVersion.DEBIAN_13).map(DebianUsesUbuntuPackageFinder::matchingUbuntuVersion).filter(Optional::isPresent).map(Optional::get).distinct().collect(Collectors.toList());
        return ubuntuVersions.stream().map(uv -> Arrays.stream(DebianVersion.values()).filter(v -> {
            Optional<UbuntuVersion> ubuntuVersion = DebianUsesUbuntuPackageFinder.matchingUbuntuVersion(v);
            return ubuntuVersion.isPresent() && ubuntuVersion.get() == uv;
        }).map(Enum::name).collect(Collectors.joining(", ", "" + uv.name() + " for ", ""))).collect(Collectors.joining(" and ", "use ", ""));
    }

    public static ImmutablePlatformMatch platformMatch() {
        return PlatformMatch.withOs((OS)CommonOS.Linux).withVersion(new Version[]{DebianVersion.DEBIAN_12, DebianVersion.DEBIAN_13});
    }

    private static Optional<UbuntuVersion> matchingUbuntuVersion(DebianVersion debianVersion) {
        switch (debianVersion) {
            case DEBIAN_12: 
            case DEBIAN_13: {
                return Optional.of(UbuntuVersion.Ubuntu_22_04);
            }
        }
        return Optional.empty();
    }
}

