/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver.linux;

import de.flapdoodle.embed.mongo.packageresolver.Command;
import de.flapdoodle.embed.mongo.packageresolver.DistributionMatch;
import de.flapdoodle.embed.mongo.packageresolver.HasPlatformMatchRules;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePackageFinderRule;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePackageFinderRules;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinderRule;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinderRules;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatch;
import de.flapdoodle.embed.mongo.packageresolver.UrlTemplatePackageResolver;
import de.flapdoodle.embed.mongo.packageresolver.VersionRange;
import de.flapdoodle.embed.process.config.store.DistributionPackage;
import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.config.store.ImmutableFileSet;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.os.BitSize;
import de.flapdoodle.os.CPUType;
import de.flapdoodle.os.OS;
import de.flapdoodle.os.Version;
import de.flapdoodle.os.linux.DebianVersion;
import java.util.Optional;

public class DebianPackageResolver
implements PackageFinder,
HasPlatformMatchRules {
    private final ImmutablePackageFinderRules rules;

    public DebianPackageResolver(Command command) {
        this.rules = DebianPackageResolver.rules(command);
    }

    @Override
    public PackageFinderRules rules() {
        return this.rules;
    }

    @Override
    public Optional<DistributionPackage> packageFor(Distribution distribution) {
        return this.rules.packageFor(distribution);
    }

    private static PlatformMatch match(BitSize bitSize, CPUType cpuType, DebianVersion ... versions) {
        return PlatformMatch.withOs(OS.Linux).withBitSize(bitSize).withCpuType(cpuType).withVersion((Version[])versions);
    }

    private static ImmutablePackageFinderRules rules(Command command) {
        ImmutableFileSet fileSet = FileSet.builder().addEntry(FileType.Executable, command.commandName()).build();
        DistributionMatch debian9MongoVersions = DistributionMatch.any(VersionRange.of("5.0.12", "5.0.14"), VersionRange.of("5.0.5", "5.0.6"), VersionRange.of("5.0.0", "5.0.2"), VersionRange.of("4.4.16", "4.4.18"), VersionRange.of("4.4.13", "4.4.13"), VersionRange.of("4.4.11", "4.4.11"), VersionRange.of("4.4.0", "4.4.9"), VersionRange.of("4.2.22", "4.2.23"), VersionRange.of("4.2.18", "4.2.19"), VersionRange.of("4.2.5", "4.2.16"), VersionRange.of("4.2.0", "4.2.3"), VersionRange.of("4.0.0", "4.0.28"), VersionRange.of("3.6.5", "3.6.23"));
        ImmutablePackageFinderRule debian9 = PackageFinderRule.builder().match(DebianPackageResolver.match(BitSize.B64, CPUType.X86, DebianVersion.DEBIAN_9).andThen(debian9MongoVersions)).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-debian92-{version}.tgz").build()).build();
        ImmutablePackageFinderRule debian9tools = PackageFinderRule.builder().match(DebianPackageResolver.match(BitSize.B64, CPUType.X86, DebianVersion.DEBIAN_9).andThen(debian9MongoVersions)).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-debian92-x86_64-{tools.version}.tgz").build()).build();
        DistributionMatch debian10MongoVersions = DistributionMatch.any(VersionRange.of("6.0.1", "6.0.4"), VersionRange.of("5.0.12", "5.0.14"), VersionRange.of("5.0.5", "5.0.6"), VersionRange.of("5.0.0", "5.0.2"), VersionRange.of("4.4.16", "4.4.18"), VersionRange.of("4.4.13", "4.4.13"), VersionRange.of("4.4.11", "4.4.11"), VersionRange.of("4.4.0", "4.4.9"), VersionRange.of("4.2.22", "4.2.23"), VersionRange.of("4.2.18", "4.2.19"), VersionRange.of("4.2.5", "4.2.16"), VersionRange.of("4.2.1", "4.2.3"));
        ImmutablePackageFinderRule debian10 = PackageFinderRule.builder().match(DebianPackageResolver.match(BitSize.B64, CPUType.X86, DebianVersion.DEBIAN_10, DebianVersion.DEBIAN_11, DebianVersion.DEBIAN_12).andThen(debian10MongoVersions)).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-debian10-{version}.tgz").build()).build();
        ImmutablePackageFinderRule debian10tools = PackageFinderRule.builder().match(DebianPackageResolver.match(BitSize.B64, CPUType.X86, DebianVersion.DEBIAN_10, DebianVersion.DEBIAN_11, DebianVersion.DEBIAN_12).andThen(debian10MongoVersions)).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-debian10-x86_64-{tools.version}.tgz").build()).build();
        DistributionMatch debian11MongoVersions = DistributionMatch.any(VersionRange.of("6.0.1", "6.0.4"), VersionRange.of("5.0.12", "5.0.14"));
        ImmutablePackageFinderRule debian11 = PackageFinderRule.builder().match(DebianPackageResolver.match(BitSize.B64, CPUType.X86, DebianVersion.DEBIAN_11, DebianVersion.DEBIAN_12).andThen(debian11MongoVersions)).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-debian11-{version}.tgz").build()).build();
        ImmutablePackageFinderRule debian11tools = PackageFinderRule.builder().match(DebianPackageResolver.match(BitSize.B64, CPUType.X86, DebianVersion.DEBIAN_10, DebianVersion.DEBIAN_11, DebianVersion.DEBIAN_12).andThen(debian11MongoVersions)).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-debian10-x86_64-{tools.version}.tgz").build()).build();
        switch (command) {
            case MongoDump: 
            case MongoImport: 
            case MongoRestore: {
                return PackageFinderRules.empty().withRules(debian11tools, debian10tools, debian9tools);
            }
        }
        return PackageFinderRules.empty().withRules(debian11, debian10, debian9);
    }
}

